package ca.training.bigdata.spark.streaming.kafka

import org.apache.spark.sql.SparkSession

/**
  * Created by BigDataTraining on 2018-03-16.
  */
object KafkaIntegration {

  def main(args: Array[String]): Unit = {
    val spark = SparkSession.builder().appName("Real time Bidding - Kafka Integration using Spark Streaming").getOrCreate()
    import spark.implicits._

    val ds1 = spark.readStream
      .format("kafka")
      .option("kafka.bootstrap.servers", "sandbox-hdp.hortonworks.com:6667")
      .option("subscribe", "class12Topic")
      .load()
      .selectExpr("CAST(key AS STRING)", "CAST(value AS STRING)")
      .as[(String, String)]


    val query = ds1.writeStream.outputMode("append").format("console").start()

    query.awaitTermination()

  }

}
