package ca.training.bigdata.spark.streaming.bidding

import org.apache.spark.sql.SparkSession
import org.apache.spark.sql.types._
import org.apache.spark.sql.functions._

/**
  * Created by BigDataTraining on 2018-03-14.
  */
object SlidingWindow {

  def main(args: Array[String]): Unit = {
    val spark = SparkSession.builder().appName("Real time Bidding - Sliding Window using Spark Streaming").getOrCreate()
    import spark.implicits._

    // Define the income data schema
    val bidSchema = new StructType()
      .add("bidid", StringType)
      .add("timestamp", StringType)
      .add("ipinyouid", StringType)
      .add("useragent", StringType)
      .add("IP", StringType)
      .add("region", IntegerType)
      .add("cityID", IntegerType)
      .add("adexchange", StringType)
      .add("domain", StringType)
      .add("turl", StringType)
      .add("urlid", StringType)
      .add("slotid", StringType)
      .add("slotwidth", StringType)
      .add("slotheight", StringType)
      .add("slotvisibility", StringType)
      .add("slotformat", StringType)
      .add("slotprice", StringType)
      .add("creative", StringType)
      .add("bidprice", StringType)

    // Income Data Streaming
    val streamingInputDF = spark
      .readStream
      .format("csv")
      .schema(bidSchema)
      .option("header", false)
      .option("inferSchema", true)
      .option("sep", "\t")
      .option("maxFilesPerTrigger", 1)
      .load("file:///root/TrainingOnHDP/dataset/spark/bid")

    // Print out Schema
    streamingInputDF.printSchema()

    // Sliding window-based functionality section
    val ts = unix_timestamp($"timestamp", "yyyyMMddHHmmssSSS").cast("timestamp")
    val streamingCityTimeDF = streamingInputDF.withColumn("ts", ts).select($"cityID", $"ts")

    // Wait for the output show on the screen after the next statement
    val windowedCounts = streamingCityTimeDF
      .groupBy(window($"ts", "10 minutes", "5 minutes"), $"cityID")
      .count()
      .writeStream
      .outputMode("complete")
      .format("console")
      .start()

    windowedCounts.awaitTermination()

  }

}
