package ca.training.bigdata.spark.streaming

import org.apache.spark.sql.SparkSession
import org.apache.spark.streaming.{Seconds, StreamingContext}

/**
  * Created by BigDataTraining on 2018-03-14.
  */
object TransformWithExample {

  def main(args: Array[String]): Unit = {
    val spark = SparkSession.builder().appName("TransformWith Example").getOrCreate()
    val sc = spark.sparkContext
    val ssc = new StreamingContext(sc, batchDuration = Seconds(5))

    val ns = sc.parallelize(0 to 2)
    import org.apache.spark.streaming.dstream.ConstantInputDStream
    val nums = new ConstantInputDStream(ssc, ns)

    val ws = sc.parallelize(Seq("zero", "one", "two"))
    import org.apache.spark.streaming.dstream.ConstantInputDStream
    val words = new ConstantInputDStream(ssc, ws)

    import org.apache.spark.rdd.RDD
    import org.apache.spark.streaming.Time
    val transformFunc: (RDD[Int], RDD[String], Time) => RDD[(Int, String)] = { case (ns, ws, time) =>
      println(s">>> ns: $ns")
      println(s">>> ws: $ws")
      println(s">>> batch: $time")

      ns.zip(ws)
    }
    nums.transformWith(words, transformFunc).print

    ssc.start()
    ssc.awaitTermination()

  }
}
