package ca.training.bigdata.kafka.partition;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class Producer implements Runnable {

  private final KafkaProducer<String, String> producer;
  private final String topic;

  public Producer(String brokers, String topic) {
    Properties prop = createProducerConfig(brokers);
    this.producer = new KafkaProducer<String, String>(prop);
    this.topic = topic;
  }

  private static Properties createProducerConfig(String brokers) {
    Properties props = new Properties();
    props.put("bootstrap.servers", brokers);
    props.put("acks", "all");
    props.put("retries", 0);
    props.put("batch.size", 16384);
    props.put("linger.ms", 1);
    props.put("buffer.memory", 33554432);
    props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
    props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
    props.put("partitioner.class",
        "ca.training.bigdata.kafka.partition.CustomPatitioner");
    return props;
  }

  @Override
  public void run() {

    Map<String, String> stocks = new HashMap();
    stocks.put("APPL", "Apple");
    stocks.put("MSFT", "Microsoft");
    stocks.put("GOOGL", "Google");

    for (String key : stocks.keySet()) {

      String msg = "Hello " + stocks.get(key);
      producer.send(new ProducerRecord<String, String>(topic, key, msg), new Callback() {
        public void onCompletion(RecordMetadata metadata, Exception e) {
          if (e != null) {
            e.printStackTrace();
          }
          System.out
              .println("Sent:" + msg + ", Key: " + key + ", Partition: " + metadata.partition());
        }
      });
      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }

    }

    producer.close();

  }
}
