package ca.training.bigdata.kafka.partition;

public final class ProcessingApp {

  public static void main(String[] args) {

    String brokers = "sandbox-hdp.hortonworks.com:6667";
    String groupId = "consumerGroup";
    String topic = "partition-topic";

    if (args != null && args.length == 3) {
      brokers = args[0];
      groupId = args[1];
      topic = args[2];
    }

    Producer producerThread = new Producer(brokers, topic);
    Thread t1 = new Thread(producerThread);
    t1.start();

    Consumer consumerThread = new Consumer(brokers, groupId, topic);
    Thread t2 = new Thread(consumerThread);
    t2.start();

    try {
      Thread.sleep(100000);
    } catch (InterruptedException ie) {

    }
  }
}
