#!/bin/bash

export KYLIN_HOME=/root/TrainingOnHDP/apache-kylin-2.2.0-bin

source ${KYLIN_HOME}/bin/check-env.sh
job_jar=`find -L ${KYLIN_HOME}/lib/ -name kylin-job*.jar`

hadoop fs -chmod -R 777 /tmp/kylin

hbase org.apache.hadoop.util.RunJar ${job_jar} org.apache.kylin.common.persistence.ResourceTool upload /root/TrainingOnHDP/StocksStreamingOnKylin/lab/stocks_cube/metadata  || { exit 1; }

echo "Streaming stocks cube is created successfully in project 'streaming_stocks."

echo "Restart Kylin server or reload the metadata from web UI to see the change."
