package ca.training.bigdata.spark.sql.etl

import org.apache.spark.sql.SparkSession

/**
  * Created by BigDataTraining on 2018-03-10.
  */
object ProcessingJSONData {

  def main(args: Array[String]): Unit = {
    val spark = SparkSession.builder().appName("Provessing JSON Data Using Spark SQL").getOrCreate()
    import spark.implicits._
    val sc = spark.sparkContext

    val opts = scala.collection.mutable.Map(
      "url" -> "jdbc:mysql://localhost:3306/spark",
      "driver" -> "com.mysql.jdbc.Driver",
      "numPartitions" -> "1",
      "dbtable" -> "online_retail")

    opts("user") = "root"
    opts("password") = "hadoop"

    val df = spark.read.json("/tmp/reviews_Musical_Instruments_5.json")
    df.printSchema()
    df.createOrReplaceTempView("musical_instruments_reviews")

    val df1 = spark.sql("SELECT asin, overall, reviewTime, reviewerID, reviewerName FROM musical_instruments_reviews WHERE overall >= 3")
    df1.show()
    df1.write
      .mode("overwrite")
      .format("jdbc")
      .options(opts)
      .option("dbtable", "musical_instruments_positive_reviews")
      .save

    val df2 = df.select($"asin", $"overall", $"helpful".getItem(0).as("helpful_reviews"),
      $"helpful".getItem(1).as("total_reviews"), $"reviewerID", $"reviewerName")
      .where($"helpful".getItem(0) >= 3)
    df2.show()
    df2.write
      .mode("overwrite")
      .format("jdbc")
      .options(opts)
      .option("dbtable", "musical_instruments_helpful_reviews")
      .save

  }


}
