package ca.training.bigdata.spark.sql.catalyst

import org.apache.spark.sql.{Row, SQLContext}
import org.apache.spark.sql.sources.{BaseRelation, TableScan}
import org.apache.spark.sql.types.{IntegerType, StructType}

/**
  * Created by BigDataTraining on 2018-03-17.
  */
case class SimpleRelation(
                           start: Int,
                           end: Int)(
                           @transient val sqlContext: SQLContext)
  extends BaseRelation with TableScan {

  val schema = new StructType().add("a", IntegerType)

  def buildScan() = sqlContext.sparkContext.parallelize(start to end).map(Row(_))

}