package ca.training.bigdata.spark.sql.catalyst

import org.apache.spark.sql.SparkSession

/**
  * Created by BigDataTraining on 2018-03-10.
  */
object RegularSimpleJoin {

  def main(args: Array[String]): Unit = {
    val spark = SparkSession
      .builder()
      .appName("Regular Simple Join")
      .enableHiveSupport()
      .getOrCreate()
    import spark.implicits._
    val sqlContext = spark.sqlContext

    sqlContext.baseRelationToDataFrame(SimpleRelation(1,1)(sqlContext)).registerTempTable("smallTable")

    sqlContext.baseRelationToDataFrame(SimpleRelation(1, 10000000)(sqlContext)).registerTempTable("bigTable")

    val query = spark.sql("SELECT * FROM smallTable s JOIN bigTable b ON s.a = b.a")

    query.explain(extended = true)

    query.collect().foreach(println)
  }

}
