package ca.training.bigdata.spark.sql.catalyst

import org.apache.spark.sql.{SparkSession, Strategy}
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan
import org.apache.spark.sql.execution.SparkPlan

/**
  * Created by BigDataTraining on 2018-03-10.
  */
object ExtendSparkSQL {

  object CustomStrategy extends Strategy {
    def apply(plan: LogicalPlan): Seq[SparkPlan] = {
      println("Custom Strategy")
      Nil
    }
  }

  def main(args: Array[String]): Unit = {
    val spark = SparkSession
      .builder()
      .appName("Extend Spark SQL using Custom Strategy")
      .enableHiveSupport()
      .getOrCreate()
    import spark.implicits._
    val sc = spark.sparkContext

    spark.experimental.extraStrategies = Seq(CustomStrategy)
    val query = spark.catalog.listTables().filter(_.name startsWith "kylin")
    query.explain(extended = true)
    query.show()

  }

}
