#!/bin/bash

export KYLIN_HOME=/root/TrainingOnHDP/apache-kylin-2.2.0-bin

source ${KYLIN_HOME}/bin/check-env.sh
job_jar=`find -L ${KYLIN_HOME}/lib/ -name kylin-job*.jar`

echo "Going to create demo tables in hive..."
cd /root/TrainingOnHDP/SalesBatchOnKylin/lab/sales_cube/data

echo "Loading demo data into HDFS tmp path: /tmp/kylin/sales_cube/data"

if $(hadoop fs -test -d /tmp/kylin/sales_cube/data) ; then hadoop fs -rm -R -skipTrash /tmp/kylin/sales_cube/data; else echo ""; fi

# if $(hadoop fs -test -d /tmp/kylin/sales_cube/data) ; then echo "/tmp/kylin/sales_cube/data already exists";else hadoop fs -mkdir -p /tmp/kylin/sales_cube/data; hadoop fs -mkdir -p /tmp/kylin/sales_cube/data/customer; hadoop fs -mkdir -p /tmp/kylin/sales_cube/data/store; hadoop fs -mkdir -p /tmp/kylin/sales_cube/data/product; hadoop fs -mkdir -p /tmp/kylin/sales_cube/data/sales; hadoop fs -mkdir -p /tmp/kylin/sales_cube/data/inventory; hadoop fs -put customer.txt /tmp/kylin/sales_cube/data/customer; hadoop fs -put product.txt /tmp/kylin/sales_cube/data/product;hadoop fs -put store.txt /tmp/kylin/sales_cube/data/store;hadoop fs -put inventory.txt /tmp/kylin/sales_cube/data/inventory;hadoop fs -put sales /tmp/kylin/sales_cube/data/sales;fi
if $(hadoop fs -test -d /tmp/kylin/sales_cube/data) ; then echo "/tmp/kylin/sales_cube/data already exists";else hadoop fs -mkdir -p /tmp/kylin/sales_cube/data; hadoop fs -put *.txt /tmp/kylin/sales_cube/data/;fi

hadoop fs -chmod -R 777 /tmp/kylin

hive -f /root/TrainingOnHDP/SalesBatchOnKylin/lab/sales_cube/create_sales_tables.sql  || { exit 1; }

hbase org.apache.hadoop.util.RunJar ${job_jar} org.apache.kylin.common.persistence.ResourceTool upload /root/TrainingOnHDP/SalesBatchOnKylin/lab/sales_cube/metadata  || { exit 1; }

echo "Sales cube is created successfully in project 'sales_demo'."

echo "Restart Kylin server or reload the metadata from web UI to see the change."
