CREATE DATABASE IF NOT EXISTS kylin_sales;

DROP TABLE IF EXISTS kylin_sales.customer;
DROP TABLE IF EXISTS kylin_sales.store;
DROP TABLE IF EXISTS kylin_sales.product;
DROP TABLE IF EXISTS kylin_sales.inventory;
DROP TABLE IF EXISTS kylin_sales.sales;

use kylin_sales;

CREATE TABLE IF NOT EXISTS customer(
   customer_id int,
   account_num bigint,
   lname varchar(30),
   fname varchar(30),
   mi varchar(30),
   address1 varchar(30),
   address2 varchar(30),
   address3 varchar(30),
   address4 varchar(30),
   city varchar(30),
   state_province varchar(30),
   postal_code varchar(30),
   country varchar(30),
   customer_region_id int,
   phone1 varchar(30),
   phone2 varchar(30),
   birthdate date,
   marital_status varchar(30),
   yearly_income varchar(30),
   gender varchar(30),
   total_children smallint,
   num_children_at_home smallint,
   education varchar(30),
   date_accnt_opened date,
   member_card varchar(30),
   occupation varchar(30),
   houseowner varchar(30),
   num_cars_owned int,
   fullname varchar(60)
)
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '|'
STORED AS TEXTFILE;

LOAD DATA INPATH '/tmp/kylin/sales_cube/data/customer.txt' OVERWRITE INTO TABLE customer;

CREATE TABLE IF NOT EXISTS store(
   store_id int,
   store_type varchar(30),
   region_id int,
   store_name varchar(30),
   store_number int,
   store_street_address varchar(30),
   store_city varchar(30),
   store_state varchar(30),
   store_postal_code varchar(30),
   store_country varchar(30),
   store_manager varchar(30),
   store_phone varchar(30),
   store_fax varchar(30),
   first_opened_date timestamp,
   last_remodel_date timestamp,
   store_sqft int,
   grocery_sqft int,
   frozen_sqft int,
   meat_sqft int,
   coffee_bar boolean,
   video_store boolean,
   salad_bar boolean,
   prepared_food boolean,
   florist boolean
)
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '|'
STORED AS TEXTFILE;

LOAD DATA INPATH '/tmp/kylin/sales_cube/data/store.txt' OVERWRITE INTO TABLE store;

CREATE TABLE IF NOT EXISTS product(
   product_class_id int,
   product_id int,
   brand_name varchar(60),
   product_name varchar(60),
   sku bigint,
   srp decimal(10,4),
   gross_weight double,
   net_weight double,
   recyclable_package boolean,
   low_fat boolean,
   units_per_case smallint,
   cases_per_pallet smallint,
   shelf_width double,
   shelf_height double,
   shelf_depth double
)
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '|'
STORED AS TEXTFILE;

LOAD DATA INPATH '/tmp/kylin/sales_cube/data/product.txt' OVERWRITE INTO TABLE product;


CREATE TABLE IF NOT EXISTS inventory(
   product_id int,
   time_id int,
   warehouse_id int,
   store_id int,
   units_ordered int,
   units_shipped int,
   warehouse_sales decimal(10,4),
   warehouse_cost decimal(10,4),
   supply_time smallint,
   store_invoice decimal(10,4)
)
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '|'
STORED AS TEXTFILE;

LOAD DATA INPATH '/tmp/kylin/sales_cube/data/inventory.txt' OVERWRITE INTO TABLE inventory;


CREATE TABLE IF NOT EXISTS sales(
   product_id int,
   time_id int,
   customer_id int,
   promotion_id int,
   store_id int,
   store_sales decimal(10,4),
   store_cost decimal(10,4),
   unit_sales decimal(10,4)
)
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '|'
STORED AS TEXTFILE;

LOAD DATA INPATH '/tmp/kylin/sales_cube/data/sales.txt' OVERWRITE INTO TABLE sales;