#!/bin/bash

echo "Initialization is started......."
if $(hadoop fs -test -d /user/root/oozie) ; then echo "/user/root/oozie already exists";else hadoop fs -mkdir /user/root/oozie; fi
if $(hadoop fs -test -d /user/root/oozie/workflow) ; then echo "/user/root/oozie/workflow already exists";else hadoop fs -mkdir /user/root/oozie/workflow; fi
if $(hadoop fs -test -d /user/root/oozie/coordinator) ; then echo "/user/root/oozie/coordinator already exists";else hadoop fs -mkdir /user/root/oozie/coordinator; fi
if $(hadoop fs -test -d /user/root/oozie/bundle) ; then echo "/user/root/oozie/bundle already exists";else hadoop fs -mkdir /user/root/oozie/bundle; fi
if $(hadoop fs -test -d /user/root/oozie/input) ; then echo "/user/root/oozie/input already exists";else hadoop fs -mkdir /user/root/oozie/input; fi
if $(hadoop fs -test -d /user/root/oozie/output) ; then echo "/user/root/oozie/output already exists";else hadoop fs -mkdir /user/root/oozie/output; fi
if $(hadoop fs -test -d /user/root/oozie/lib) ; then echo "/user/root/oozie/lib already exists";else hadoop fs -mkdir /user/root/oozie/lib; fi
if $(hadoop fs -test -d /user/root/oozie/scripts) ; then echo "/user/root/oozie/scripts already exists";else hadoop fs -mkdir /user/root/oozie/scripts; fi
if $(hadoop fs -test -d /user/root/oozie/tmp) ; then echo "/user/root/oozie/tmp already exists";else hadoop fs -mkdir /user/root/oozie/tmp; fi
hadoop fs -chmod 777 /user/root/oozie
hadoop fs -chmod 777 /user/root/oozie/workflow
hadoop fs -chmod 777 /user/root/oozie/coordinator
hadoop fs -chmod 777 /user/root/oozie/bundle
hadoop fs -chmod 777 /user/root/oozie/input
hadoop fs -chmod 777 /user/root/oozie/output
hadoop fs -chmod 777 /user/root/oozie/lib
hadoop fs -chmod 777 /user/root/oozie/scripts
hadoop fs -chmod 777 /user/root/oozie/tmp
echo "Initialization is done......."

echo "Start to deploy oozie workflow......."
if $(hadoop fs -test -f /user/root/oozie/workflow/kylin_cube_build.xml) ; then hadoop fs -rm -skipTrash /user/root/oozie/workflow/kylin_cube_build.xml; else echo "/user/root/oozie/workflow/kylin_cube_build.xml not exist and will be created"; fi
hadoop fs -put /root/TrainingOnHDP/SalesBatchOnKylin/lab/oozie/kylin_cube_build.xml /user/root/oozie/workflow
hadoop fs -chmod 777 /user/root/oozie/workflow/kylin_cube_build.xml
echo "Oozie workflow is deployed......."

echo "Start to deploy oozie coordinator......."
if $(hadoop fs -test -f /user/root/oozie/coordinator/kylin_cube_build_coord.xml) ; then hadoop fs -rm -skipTrash /user/root/oozie/coordinator/kylin_cube_build_coord.xml; else echo "/user/root/oozie/coordinator/kylin_cube_build_coord.xml not exist and will be created"; fi
hadoop fs -put /root/TrainingOnHDP/SalesBatchOnKylin/lab/oozie/kylin_cube_build_coord.xml /user/root/oozie/coordinator
hadoop fs -chmod 777 /user/root/oozie/coordinator/kylin_cube_build_coord.xml
echo "Oozie coordinator is deployed......."

echo "Start to deploy oozie action scripts......"
if $(hadoop fs -test -f /user/root/oozie/scripts/kylin_cube_build.sh) ; then hadoop fs -rm -skipTrash /user/root/oozie/scripts/kylin_cube_build.sh; else echo "/user/root/oozie/scripts/kylin_cube_build.sh not exist and will be created"; fi
hadoop fs -put /root/TrainingOnHDP/SalesBatchOnKylin/lab/oozie/kylin_cube_build.sh /user/root/oozie/scripts
hadoop fs -chmod 777 /user/root/oozie/scripts/kylin_cube_build.sh
echo "Oozie action scripts are deployed......."


echo "Start to run oozie workflow......"
oozie job -oozie http://127.0.0.1:11000/oozie -config /root/TrainingOnHDP/SalesBatchOnKylin/lab/oozie/job.properties -run
echo "Oozie workflow is started......."

echo "Start to run oozie coordinator......"
oozie job -oozie http://127.0.0.1:11000/oozie -config /root/TrainingOnHDP/SalesBatchOnKylin/lab/oozie/coordinator.properties -run
echo "Oozie coordinator is started......."

