#!/bin/bash

export KYLIN_HOME=/opt/apache-kylin-1.6.0-hbase1.x-bin

source ${KYLIN_HOME}/bin/check-env.sh
job_jar=`find -L ${KYLIN_HOME}/lib/ -name kylin-job*.jar`

echo "Going to create demo tables in hive..."
cd /training/apps/kylin/project1/ctr_cube/data

echo "Loading demo data into HDFS tmp path: /tmp/kylin/ctr_cube/data"
if $(hadoop fs -test -d /tmp/kylin/ctr_cube/data) ; then echo "/tmp/kylin/ctr_cube/data already exists";else hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/training; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/user; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/query; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/keyword; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/title; hadoop fs -mkdir -p /tmp/kylin/ctr_cube/data/description; hadoop fs -put flights_2007.csv.bz2 /tmp/kylin/ctr_cube/data/training; hadoop fs -put weather_2007.csv.gz /tmp/kylin/c_cube/data/user;hadoop fs -put weather_2007.csv.gz /tmp/kylin/ctr_cube/data/title;hadoop fs -put weather_2007.csv.gz /tmp/kylin/ctr_cube/data/keyword;hadoop fs -put weather_2007.csv.gz /tmp/kylin/ctr_cube/data/query;hadoop fs -put weather_2007.csv.gz /tmp/kylin/ctr_cube/data/description;fi

hadoop fs -chmod -R 777 /tmp/kylin

hive -f /training/apps/kylin/project1/demo_cube/create_ctr_tables.sql  || { exit 1; }

# hbase org.apache.hadoop.util.RunJar ${job_jar} org.apache.kylin.common.persistence.ResourceTool upload /training/apps/kylin/project1/demo_cube/metadata  || { exit 1; }

echo "Demo cube is created successfully in project 'ctr_demo'."

echo "Restart Kylin server or reload the metadata from web UI to see the change."
