package ca.training.bigdata.spark

import org.apache.spark.sql.SparkSession
import org.apache.spark.sql.functions._

object MySQL2Hive {

  def main(args: Array[String]): Unit = {

    val spark = SparkSession
      .builder()
      .appName("Move data from MySQL to Hadoop using Spark JDBC")
      .enableHiveSupport()
      .getOrCreate()

    val options = Map(
      "driver" -> "com.mysql.jdbc.Driver",
      "url" -> "jdbc:mysql://localhost:3306/foodmart_spark",
      "user" -> "root",
      "password" -> "hadoop",
      "dbtable" -> "foodmart_spark.customer"
    )

    var df = spark.read.format("jdbc").options(options).load()
    df.cache()
    df.write.mode("overwrite").format("parquet").save("/root/data/foodmart_spark/customer")
    df.write.mode("overwrite").format("orc").saveAsTable("foodmart_spark.customer")

    df = spark.read.format("jdbc").options(options).option("dbtable", "foodmart_spark.product").load()
    df.cache()
    df.write.mode("overwrite").format("parquet").save("/root/data/foodmart_spark/product")
    df.write.mode("overwrite").format("orc").saveAsTable("foodmart_spark.product")

    df = spark.read.format("jdbc").options(options).option("dbtable", "foodmart_spark.store").load()
    df.cache()
    df.write.mode("overwrite").format("parquet").save("/root/data/foodmart_spark/store")
    df.write.mode("overwrite").format("orc").saveAsTable("foodmart_spark.store")

    df = spark.read.format("jdbc").options(options).option("dbtable", "foodmart_spark.inventory_fact_1998").load()
    df.cache()
    df.write.mode("overwrite").format("json").save("/root/data/foodmart_spark/inventory_fact_1998")
    df.write.mode("overwrite").format("orc").saveAsTable("foodmart_spark.inventory_fact_1998")

    df = spark.read.format("jdbc").options(options).option("dbtable", "foodmart_spark.sales_fact_dec_1998").load()
    df.cache()
    df.write.mode("overwrite").format("csv").save("/root/data/foodmart_spark/sales_fact_dec_1998")
    df.write.mode("overwrite").format("orc").saveAsTable("foodmart_spark.sales_fact_dec_1998")

  }
}
