package ca.training.bigdata.spark

import org.apache.spark.SparkConf
import org.apache.spark.sql.SparkSession
import org.apache.spark.storage.StorageLevel
import org.apache.spark.streaming._
import org.apache.spark.streaming.kafka._

object Kafka2HDFS {

  def main(args: Array[String]): Unit = {

    val sparkConf = new SparkConf().setAppName("Move data from Kafka to HDFS using Spark Streaming")

    val ssc = new StreamingContext(sparkConf, Seconds(30))

    val topicMap = "mysql-jdbc-demo_products".split(",").map((_, 1)).toMap
    val lines = KafkaUtils.createStream(ssc, "localhost:2181", "mysql", topicMap, StorageLevel.MEMORY_AND_DISK_SER_2).map(_._2)

    lines.foreachRDD( rdd => {
      val spark = SparkSession.builder.config(rdd.sparkContext.getConf).getOrCreate()
      import spark.implicits._
      var df = rdd.toDF("record")
      df.createOrReplaceTempView("record")
      df = spark.sql("select * from record")
      df.write.mode("append").format("text").save("/root/data/foodmart_spark/demo_products")
    })

    ssc.start()
    ssc.awaitTermination()

  }
}
