package ca.training.bigdata.spark

import org.apache.spark.sql.SparkSession
import org.apache.spark.sql.functions._

object Hive2MySQL {

  def main(args: Array[String]): Unit = {

    val spark = SparkSession
      .builder()
      .appName("Move data from Hive to MySQL using Spark JDBC")
      .enableHiveSupport()
      .getOrCreate()

    val options = Map(
      "driver" -> "com.mysql.jdbc.Driver",
      "url" -> "jdbc:mysql://localhost:3306/foodmart_spark",
      "user" -> "root",
      "password" -> "hadoop",
      "dbtable" -> "foodmart_spark.customer"
    )

    var df = spark.sql("select * from foodmart.customer")
    df.write.mode("overwrite").format("jdbc").options(options)
      .option("dbtable", "foodmart_spark.customer").save()

    df = spark.sql("select * from foodmart.product")
    df.write.mode("overwrite").format("jdbc").options(options)
      .option("dbtable", "foodmart_spark.product").save()

    df = spark.sql("select * from foodmart.store")
    df = df.withColumn("last_remodel_date", col("last_remodel_date").cast("date"))
    df = df.withColumn("first_opened_date", col("first_opened_date").cast("date"))
    df.write.mode("overwrite").format("jdbc").options(options)
      .option("dbtable", "foodmart_spark.store").save()

    df = spark.sql("select * from foodmart.inventory_fact_1998")
    df.write.mode("overwrite").format("jdbc").options(options)
      .option("dbtable", "foodmart_spark.inventory_fact_1998").save()

    df = spark.sql("select * from foodmart.sales_fact_dec_1998")
    df.write.mode("overwrite").format("jdbc").options(options)
      .option("dbtable", "foodmart_spark.sales_fact_dec_1998").save()

  }
}
