package ca.training.bigdata.hive.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
/**
 * Created by BigDataTraining on 2017-03-07.
 */
public final class CalHolidaysGap  extends UDF {

    String[] holidays = {"01/01/2007", "01/15/2007", "02/19/2007", "05/28/2007", "06/07/2007", "07/04/2007",
            "09/03/2007", "10/08/2007", "11/11/2007", "11/22/2007", "12/25/2007",
            "01/01/2008", "01/21/2008", "02/18/2008", "05/22/2008", "05/26/2008", "07/04/2008",
            "09/01/2008", "10/13/2008", "11/11/2008", "11/27/2008", "12/25/2008"};

    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    public LongWritable evaluate(final IntWritable year, IntWritable month, IntWritable day) {
        Calendar start = Calendar.getInstance();
        start.set(year.get(), month.get(), day.get());
        long startTime = start.getTime().getTime();
        long endTime = 0;
        Date end = null;
        long diffDays = 3000;
        for (String holiday : holidays) {
            try {
                end = (Date) dateFormat.parse(holiday);
            }catch(Exception e){}
            endTime = end.getTime();
            long diffTime = Math.abs(endTime - startTime);
            if (diffDays > diffTime / (1000 * 60 * 60 * 24))
                diffDays = Math.round(diffTime / (1000 * 60 * 60 * 24));
        }
        return new LongWritable(diffDays);
    }
}