package ca.training.bigdata.hbase

import org.apache.spark.sql.{DataFrame, SparkSession}
import org.apache.spark.sql.execution.datasources.hbase.HBaseTableCatalog

object SVEpisodesToHBase {

  def main(args: Array[String]): Unit = {

    val cat =
      s"""{
                  "table":{"namespace":"default", "name":"svepisodes"},
                  "rowkey":"key",
                  "columns":{
                    "id":{"cf":"rowkey", "col":"key", "type":"long"},
                    "airdate":{"cf":"SVE", "col":"Airdate", "type":"string"},
                    "airstamp":{"cf":"SVE", "col":"Airstamp", "type":"string"},
                    "airtime":{"cf":"SVE", "col":"Airtime", "type":"string"},
                    "name":{"cf":"SVE", "col":"Name", "type":"string"},
                    "number":{"cf":"SVE", "col":"Number", "type":"long"},
                    "runtime":{"cf":"SVE", "col":"Runtime", "type":"long"},
                    "season":{"cf":"SVE", "col":"Season", "type":"long"},
                    "summary":{"cf":"SVE", "col":"Summary", "type":"string"},
                    "url":{"cf":"SVE", "col":"Url", "type":"string"}
                  }
                  }""".stripMargin

    val spark = SparkSession.builder().appName("SV Episodes to HBase").getOrCreate()

    val svEpisodes = spark.read.json("/tmp/svepisodes.json")
    svEpisodes.printSchema()
    svEpisodes.show()

    svEpisodes.write.options(Map(HBaseTableCatalog.tableCatalog -> cat, HBaseTableCatalog.newTable -> "5")).format("org.apache.spark.sql.execution.datasources.hbase").save()

  }

}
