package ca.training.bigdata.hbase

import org.apache.spark.sql.{DataFrame, SparkSession}
import org.apache.spark.sql.execution.datasources.hbase.HBaseTableCatalog

object SVEpisodesFromHBase {

  def main(args: Array[String]): Unit = {

    val cat =
      s"""{
                  "table":{"namespace":"default", "name":"svepisodes"},
                  "rowkey":"key",
                  "columns":{
                    "id":{"cf":"rowkey", "col":"key", "type":"long"},
                    "airdate":{"cf":"SVE", "col":"Airdate", "type":"string"},
                    "airstamp":{"cf":"SVE", "col":"Airstamp", "type":"string"},
                    "airtime":{"cf":"SVE", "col":"Airtime", "type":"string"},
                    "name":{"cf":"SVE", "col":"Name", "type":"string"},
                    "number":{"cf":"SVE", "col":"Number", "type":"long"},
                    "runtime":{"cf":"SVE", "col":"Runtime", "type":"long"},
                    "season":{"cf":"SVE", "col":"Season", "type":"long"},
                    "summary":{"cf":"SVE", "col":"Summary", "type":"string"},
                    "url":{"cf":"SVE", "col":"Url", "type":"string"}
                  }
                  }""".stripMargin

    val spark = SparkSession.builder().appName("SV Episodes from HBase").getOrCreate()

    val df = spark
      .sqlContext
      .read.options(Map(HBaseTableCatalog.tableCatalog->cat)).format("org.apache.spark.sql.execution.datasources.hbase").load()

    df.registerTempTable("svepisodes")

    spark.sql("select * from svepisodes").show()

  }

}
