package ca.training.bigdata.hbase.coprocessor;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;

import java.io.IOException;
import java.util.List;

public class AirDelayDataObserver extends BaseRegionObserver {

    @Override
    public void preGetOp(final ObserverContext<RegionCoprocessorEnvironment> e, final Get get, final List<Cell> results)
            throws IOException {

        if (Bytes.equals(get.getRow(), Bytes.toBytes("row008"))) {
            Cell c = CellUtil.createCell(get.getRow(), Bytes.toBytes("CF"), Bytes.toBytes("CP"), System.currentTimeMillis(), (byte)4, Bytes.toBytes("You can not see the detail of row008"));
            results.add(c);
            e.bypass();
        }
    }

}
