package ca.training.bigdata.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;

import java.sql.Connection;
import java.sql.DriverManager;

public class CreditCardTransactionToHBase {

    public static void main(String[] args) {

        Configuration config = HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", "sandbox-hdp.hortonworks.com");
        config.set("hbase.zookeeper.property.clientPort", "2181");
        config.set("zookeeper.znode.parent", "/hbase-unsecure");

        HTable transactionHistoryTable = null;

        try {
            HBaseAdmin hbaseAdmin = new HBaseAdmin(config);
            if (hbaseAdmin.tableExists("TransactionHistory")) {
                transactionHistoryTable = new HTable(config, "TransactionHistory");
            } else {
                HTableDescriptor tableDescriptor = new HTableDescriptor("TransactionHistory");
                HColumnDescriptor cfColumnFamily = new HColumnDescriptor("Transactions".getBytes());
                tableDescriptor.addFamily(cfColumnFamily);
                hbaseAdmin.createTable(tableDescriptor);
                transactionHistoryTable = new HTable(config, "TransactionHistory");
            }
            hbaseAdmin.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        Put transactionToPersist = new Put(Bytes.toBytes("1111111"));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("accountNumber"), Bytes.toBytes(String.valueOf("19123")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("acountType"), Bytes.toBytes(String.valueOf("VISA")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("frauduent"), Bytes.toBytes(String.valueOf("false")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("merchantId"), Bytes.toBytes(String.valueOf("123456")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("merchantType"), Bytes.toBytes(String.valueOf("Retail")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("amount"), Bytes.toBytes(Double.valueOf(100)));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("currency"), Bytes.toBytes(String.valueOf("CAD")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("isCardPresent"), Bytes.toBytes(String.valueOf("yes")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("latitude"), Bytes.toBytes(Double.valueOf(39.919512)));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("longitude"), Bytes.toBytes(Double.valueOf(-75.005711)));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("ipAddress"), Bytes.toBytes(String.valueOf("")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("transactionId"), Bytes.toBytes(String.valueOf("1111111")));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("transactionTimeStamp"), Bytes.toBytes(Long.valueOf(111)));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("distanceFromHome"), Bytes.toBytes(Double.valueOf(100)));
        transactionToPersist.add(Bytes.toBytes("Transactions"), Bytes.toBytes("distanceFromPrev"), Bytes.toBytes(Double.valueOf(200)));
        try {
            transactionHistoryTable.put(transactionToPersist);
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            Scan scan = new Scan();
            scan.setStartRow(Bytes.toBytes("1111111"));
            scan.addColumn(Bytes.toBytes("Transactions"), Bytes.toBytes("accountNumber"));
            scan.addColumn(Bytes.toBytes("Transactions"), Bytes.toBytes("merchantId"));
            scan.addColumn(Bytes.toBytes("Transactions"), Bytes.toBytes("frauduent"));
            scan.addColumn(Bytes.toBytes("Transactions"), Bytes.toBytes("amount"));

            ResultScanner scanner = transactionHistoryTable.getScanner(scan);

            for (Result result = scanner.next(); (result != null); result = scanner.next()) {
                for (KeyValue keyValue : result.list()) {
                     System.out.println(Bytes.toString(keyValue.getQualifier()) + " : Value : " + Bytes.toString(keyValue.getValue()));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
