package ca.training.bigdata.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.*;
import org.apache.hadoop.hbase.util.Bytes;

import java.sql.Connection;
import java.sql.DriverManager;

public class CreditCardCustomerAccountToHBase {

    public static void main(String[] args) {

        Configuration config = HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", "sandbox-hdp.hortonworks.com");
        config.set("hbase.zookeeper.property.clientPort", "2181");
        config.set("zookeeper.znode.parent", "/hbase-unsecure");

        HTable customerAccountTable = null;
        Connection conn;

        try {
            HBaseAdmin hbaseAdmin = new HBaseAdmin(config);
            Class.forName("org.apache.phoenix.jdbc.PhoenixDriver");
            conn = DriverManager.getConnection("jdbc:phoenix:sandbox-hdp.hortonworks.com:2181:/hbase-unsecure");
            if (hbaseAdmin.tableExists("CustomerAccount")) {
                customerAccountTable = new HTable(config, "CustomerAccount");
            } else {
                conn.createStatement().execute("CREATE TABLE IF NOT EXISTS \"CustomerAccountBI\" ("
                        + "\"accountNumber\" VARCHAR PRIMARY KEY, "
                        + "\"CustomerDetails\".\"firstName\" VARCHAR, "
                        + "\"CustomerDetails\".\"lastName\" VARCHAR, "
                        + "\"CustomerDetails\".\"age\" VARCHAR, "
                        + "\"CustomerDetails\".\"gender\" VARCHAR, "
                        + "\"CustomerDetails\".\"streetAddress\" VARCHAR, "
                        + "\"CustomerDetails\".\"city\" VARCHAR, "
                        + "\"CustomerDetails\".\"state\" VARCHAR, "
                        + "\"CustomerDetails\".\"zipcode\" VARCHAR, "
                        + "\"CustomerDetails\".\"latitude\" DOUBLE, "
                        + "\"CustomerDetails\".\"longitude\" DOUBLE, "
                        + "\"CustomerDetails\".\"ipAddress\" VARCHAR, "
                        + "\"CustomerDetails\".\"port\" VARCHAR, "
                        + "\"AccountDetails\".\"accountNumber\" VARCHAR, "
                        + "\"AccountDetails\".\"accountType\" VARCHAR, "
                        + "\"AccountDetails\".\"accountLimit\" VARCHAR, "
                        + "\"AccountDetails\".\"isActive\" VARCHAR, "
                        + "\"AccountDetails\".\"distanceMean\" DOUBlE, "
                        + "\"AccountDetails\".\"distanceDev\" DOUBlE, "
                        + "\"AccountDetails\".\"timeDeltaSecMean\" DOUBlE, "
                        + "\"AccountDetails\".\"timeDeltaSecDev\" DOUBlE, "
                        + "\"AccountDetails\".\"conAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"conAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"gasAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"gasAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"rAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"rAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"elecAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"elecAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"entAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"entAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"hbAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"hbAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"restAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"restAmtDev\" DOUBlE, "
                        + "\"AccountDetails\".\"grocAmtMean\" DOUBlE, "
                        + "\"AccountDetails\".\"grocAmtDev\" DOUBlE)");
                conn.commit();

                conn.createStatement().executeUpdate("UPSERT INTO \"CustomerAccountBI\" VALUES("
                        + "'19123', "
                        + "'Regina', "
                        + "'SMITH', "
                        + "'32', "
                        + "'Female', "
                        + "'1234 Tampa Ave', "
                        + "'Cherry Hill', "
                        + "'NJ', "
                        + "'08003', "
                        + "39.919512, "
                        + "-75.005711, "
                        + "'' , "
                        + "'' , "
                        + "'19123', "
                        + "'VISA', "
                        + "'20000', "
                        + "'true', "
                        + "9.173712305, "
                        + "5.968364997, "
                        + "5398.577075, "
                        + "6968.79762, "
                        + "16.87915743, "
                        + "4.272822919, "
                        + "36.9679558, "
                        + "7.226414921, "
                        + "174.1947298, "
                        + "72.17713403, "
                        + "98.97291196, "
                        + "29.0160567, "
                        + "39.4743295, "
                        + "5.728492345, "
                        + "84.07411631, "
                        + "35.58637624, "
                        + "73.73396065, "
                        + "38.0403594, "
                        + "83.73396065, "
                        + "32.0403594)");
                conn.commit();

                HTableDescriptor tableDescriptor = new HTableDescriptor("CustomerAccount");
                HColumnDescriptor cfColumnFamily = new HColumnDescriptor("CustomerDetails".getBytes());
                HColumnDescriptor cfIIColumnFamily = new HColumnDescriptor("AccountDetails".getBytes());
                tableDescriptor.addFamily(cfColumnFamily);
                tableDescriptor.addFamily(cfIIColumnFamily);
                hbaseAdmin.createTable(tableDescriptor);
                customerAccountTable = new HTable(config, "CustomerAccount");
            }
            hbaseAdmin.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        Put customer1000 = new Put(Bytes.toBytes("19123"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("firstName"), Bytes.toBytes("Regina"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("lastName"), Bytes.toBytes("Smith"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("age"), Bytes.toBytes("32"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("gender"), Bytes.toBytes("Female"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("streetAddress"), Bytes.toBytes("1234 Tampa Ave."));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("city"), Bytes.toBytes("Cherry Hill"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("state"), Bytes.toBytes("NJ"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("zipcode"), Bytes.toBytes("08003"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("latitude"), Bytes.toBytes("39.919512"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("longitude"), Bytes.toBytes("-75.005711"));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("ipAddress"), Bytes.toBytes(""));
        customer1000.add(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("port"), Bytes.toBytes(""));

        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("accountNumber"), Bytes.toBytes("19123"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("accountType"), Bytes.toBytes("VISA"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("expMonth"), Bytes.toBytes("09"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("expYear"), Bytes.toBytes("19"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("accountLimit"), Bytes.toBytes("20000"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("isActive"), Bytes.toBytes("true"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("distanceMean"), Bytes.toBytes("9.173712305"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("distanceDev"), Bytes.toBytes("5.968364997"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("timeDeltaSecMean"), Bytes.toBytes("5398.577075"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("timeDeltaSecDev"), Bytes.toBytes("6968.79762"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("conAmtMean"), Bytes.toBytes("16.87915743"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("conAmtDev"), Bytes.toBytes("4.272822919"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("gasAmtMean"), Bytes.toBytes("36.9679558"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("gasAmtDev"), Bytes.toBytes("7.226414921"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("rAmtMean"), Bytes.toBytes("174.1947298"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("rAmtDev"), Bytes.toBytes("72.17713403"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("elecAmtMean"), Bytes.toBytes("98.97291196"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("elecAmtDev"), Bytes.toBytes("29.0160567"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("entAmtMean"), Bytes.toBytes("39.4743295"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("entAmtDev"), Bytes.toBytes("5.728492345"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("hbAmtMean"), Bytes.toBytes("84.07411631"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("hbAmtDev"), Bytes.toBytes("35.58637624"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("restAmtMean"), Bytes.toBytes("73.73396065"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("restAmtDev"), Bytes.toBytes("38.0403594"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("grocAmtMean"), Bytes.toBytes("83.73396065"));
        customer1000.add(Bytes.toBytes("AccountDetails"), Bytes.toBytes("grocAmtDev"), Bytes.toBytes("32.0403594"));

        try {
            customerAccountTable.put(customer1000);
        } catch (Exception e) {
            e.printStackTrace();
        }

        Get get = new Get(Bytes.toBytes("19123"));
        Result result = null;
        try {
            result = customerAccountTable.get(get);
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (result.getValue(Bytes.toBytes("AccountDetails"), Bytes.toBytes("accountNumber")) != null) {
            System.out.println("***************is active: " + Bytes.toString(result.getValue(Bytes.toBytes("AccountDetails"), Bytes.toBytes("isActive"))));
            System.out.println("***************first name: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("firstName"))));
            System.out.println("***************last name: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("lastName"))));
            System.out.println("***************age: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("age"))));
            System.out.println("***************gender: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("gender"))));
            System.out.println("***************street address: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("streetAddress"))));
            System.out.println("***************city: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("city"))));
            System.out.println("***************state: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("state"))));
            System.out.println("***************zip code: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("zipcode"))));
            System.out.println("***************home latitude: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("latitude"))));
            System.out.println("***************home longititude: " + Bytes.toString(result.getValue(Bytes.toBytes("CustomerDetails"), Bytes.toBytes("longitude"))));
        }
    }
}
