package ca.training.bigdata.mr.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class KMeansPoint implements Writable {

    private ArrayPrimitiveWritable vector = null;
    private IntWritable number = null;

    public KMeansPoint() {
        vector = new ArrayPrimitiveWritable();
        number = new IntWritable(0);
    }

    public KMeansPoint parse(String value) {
        String[] coords = value.toString().split(",");
        double[] temp = new double[coords.length];
        for (int i = 0, j = temp.length; i < j; i++) {
            temp[i] = Double.valueOf(coords[i]);
        }
        vector.set(temp);
        number.set(1);
        return this;
    }

    public double[] getVector() {
        return (double[]) vector.get();
    }

    public void setVector(double[] temp) {
        vector.set(temp);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        vector.readFields(in);
        number.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        vector.write(out);
        number.write(out);
    }

    public int getDimensions() {
        return getVector().length;
    }

    public double distance(KMeansPoint point) {
        getVector();
        double sum = 0.0f;
        double[] thisVector = this.getVector();
        double[] otherVector = point.getVector();
        if (thisVector.length != otherVector.length) {
            throw new RuntimeException();
        }
        for (int i = 0, j = thisVector.length; i < j; i++) {
            double thisCoordinate = thisVector[i];
            double otherCoordinate = otherVector[i];
            sum += Math.pow(thisCoordinate - otherCoordinate, 2);
        }
        return Math.sqrt(sum);
    }

    public void add(double[] otherVector, int nums) {
        double[] thisVector = this.getVector();
        for (int i = 0, j = thisVector.length; i < j; i++) {
            thisVector[i] = thisVector[i] + otherVector[i];
        }
        number.set(number.get() + nums);
        setVector(thisVector);
    }

    public void compress() {
        double[] thisVector = this.getVector();
        double currentNumber = number.get();
        for (int i = 0, j = thisVector.length; i < j; i++) {
            thisVector[i] /= currentNumber;
        }
        number.set(1);
        setVector(thisVector);
    }

    public String toString() {
        double[] thisVector = this.getVector();
        StringBuffer sb = new StringBuffer();
        for (int i = 0, j = thisVector.length; i < j; i++) {
            sb.append(thisVector[i]);
            if (i < thisVector.length - 1) {
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public double getNumber() {
        return number.get();
    }

    public boolean equals(Object o) {
        if (o instanceof KMeansPoint) {
            KMeansPoint p = (KMeansPoint) o;
            return Arrays.equals(getVector(), p.getVector());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getVector());
    }

    public void setNumber(int i) {
        this.number.set(i);
    }

}
