package ca.training.bigdata.mr.kmeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KMeansManager {

    private List<KMeansCentroid> centroids = null;

    public KMeansManager() throws IOException {
        centroids = new ArrayList<KMeansCentroid>();
    }

    public KMeansCentroid add(String record) {
        KMeansCentroid centroid = new KMeansCentroid().parse(record);
        return add(centroid);
    }

    public KMeansCentroid add(KMeansCentroid centroid) {
        this.centroids.add(centroid);
        return centroid;
    }

    public KMeansCentroid closest(KMeansPoint point) {
        KMeansCentroid closest = null;
        if (centroids.size() > 0) {
            closest = centroids.get(0);
            double minDist = closest.distance(point);
            for (KMeansCentroid centroid : centroids) {
                double dist = centroid.distance(point);
                if (minDist >= dist) {
                    closest = centroid;
                    minDist = dist;
                }
            }
        }
        return closest;
    }

}
