package ca.training.bigdata.mr.kmeans;

import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;

public class KMeansController {

	private Integer iteration = 0;
	private KMeansStep previousStep = null;
	private KMeansStep currentStep = null;
	private Configuration conf = null;

	public KMeansController(Configuration conf) {
		this.conf = conf;
		this.iteration = this.conf.getInt("iteration", 0);
	}

	public KMeansStep step() {
		try {
			iteration++;
			conf.setInt("iteration", iteration);
			KMeansStep tempStep = new KMeansStep(conf);
			previousStep = currentStep;
			currentStep = tempStep;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return currentStep;
	}

	public Boolean converged() {
		Boolean result = false;
		if (null != currentStep) {
			Integer max = conf.getInt("max", 0);
			if (getIteration() < max) {
				Counters counters;
				try {
					counters = currentStep.getCounters();
					Enum<?> convergedCounter = KMeansCounters.ADJUSTED;
					Counter counter = counters.findCounter(convergedCounter);
					result = (0L == counter.getValue());
					System.out.printf("Algorithm counter %s == %s\n", 0, counter.getValue());
				} catch (IOException e) {
					e.printStackTrace();
				}
			} else {
				System.out.printf("Algorithm converged max iterations\n");
				result = true;
			}
		}
		return result;
	}

	public Boolean commit() {
		try{
			Path homePath = new Path(conf.get("home"));
			FileSystem dfs = FileSystem.get(new Configuration());
			if (!dfs.isFile(homePath)) {
				dfs.createNewFile(homePath);
			}
			FSDataOutputStream dfsOutput = dfs.create(homePath);
			conf.write(dfsOutput);
			dfs.close();
			return true;
		} catch(Exception e) {
			return false;
		}
	}

	public Boolean resurrect() {
		try{
			Path homePath = new Path(conf.get("home"));
			FileSystem dfs = FileSystem.get(new Configuration());
			if (dfs.isFile(homePath)) {
				FSDataInputStream dfsInput = dfs.open(homePath);
				conf.readFields(dfsInput);
			}
			dfs.close();
			return true;
		} catch(Exception e) {
			return false;
		}
	}

	public Integer getIteration() {
		return iteration;
	}

	public KMeansStep previousStep() {
		return previousStep;
	}

	public KMeansStep currentStep() {
		return currentStep;
	}

}
