package ca.training.bigdata.mr.kmeans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

import org.apache.hadoop.mapreduce.Reducer;

public class KMeansCombiner extends Reducer<KMeansCentroid, KMeansPoint, KMeansCentroid, KMeansPoint> {

    @Override
    public void reduce(KMeansCentroid key, Iterable<KMeansPoint> points, Context context) throws IOException, InterruptedException {
        KMeansPoint result = null;
        Iterator<KMeansPoint> iterator = points.iterator();
        while (iterator.hasNext()) {
            KMeansPoint point = iterator.next();
            int count = Double.valueOf(point.getNumber()).intValue();
            double[] vector = point.getVector();
            double[] temp = Arrays.copyOf(vector, vector.length);
            if (null == result) {
                result = new KMeansPoint();
                result.setVector(temp);
                result.setNumber(count);
            } else {
                result.add(temp, count);
            }
        }
        if (null != result) {
            context.write(key, result);
        }
        return;
    }

}
