package ca.training.bigdata.mr.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class KMeansCentroid implements WritableComparable<KMeansCentroid> {

    private Text text = new Text();
    private KMeansPoint point = new KMeansPoint();

    public static KMeansCentroid calculate(Text label, Iterable<KMeansPoint> points) {
        KMeansPoint result = null;
        Iterator<KMeansPoint> iterator = points.iterator();
        while (iterator.hasNext()) {
            KMeansPoint point = iterator.next();
            double[] vector = point.getVector();
            int count = Double.valueOf(point.getNumber()).intValue();
            double[] temp = Arrays.copyOf(vector, vector.length);
            if (null == result) {
                result = new KMeansPoint();
                result.setVector(temp);
                result.setNumber(count);
            } else {
                result.add(temp, count);
            }
        }
        if (null != result) {
            result.compress();
        }
        return new KMeansCentroid(label, result);
    }

    public KMeansCentroid() {
    }

    public KMeansCentroid(Text label, KMeansPoint point) {
        this.text = label;
        this.point = point;
    }

    public KMeansCentroid parse(String value) {
        int index = value.indexOf(" ");
        this.text.set(value.substring(0, index));
        this.point.parse(value.substring(index + 1, value.length()));
        return this;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        text.readFields(in);
        point.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        text.write(out);
        point.write(out);
    }

    public Text getText() {
        return this.text;
    }

    public String getLabel() {
        return this.text.toString();
    }

    public KMeansPoint getPoint() {
        return this.point;
    }

    public double[] getVector() {
        return this.getPoint().getVector();
    }

    @Override
    public int compareTo(KMeansCentroid c) {
        return this.text.compareTo(c.getText());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof KMeansCentroid) {
            KMeansCentroid c = (KMeansCentroid) o;
            return this.text.equals(c.getText());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.text.hashCode();
    }

    public int getDimensions() {
        return this.point.getDimensions();
    }

    public double distance(KMeansCentroid centroid) {
        KMeansPoint point = centroid.getPoint();
        return this.getPoint().distance(point);
    }

    public double distance(KMeansPoint point) {
        return this.getPoint().distance(point);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText().toString());
        sb.append(" ");
        sb.append(this.getPoint());
        return sb.toString();
    }

}
