/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.google.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import shade.com.datastax.spark.connector.google.common.annotations.GwtCompatible;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableCollection;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMultiset;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;
import shade.com.datastax.spark.connector.google.common.collect.Multiset;
import shade.com.datastax.spark.connector.google.common.collect.Multisets;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer value2 = this.map.get(element);
        return value2 == null ? 0 : value2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        Map.Entry mapEntry = (Map.Entry)((ImmutableCollection)((Object)this.map.entrySet())).asList().get(index);
        return Multisets.immutableEntry(mapEntry.getKey(), (Integer)mapEntry.getValue());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

