/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.BatchSize$;
import com.datastax.spark.connector.BytesInBatch;
import com.datastax.spark.connector.RowsInBatch;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.TimestampOption$;
import com.datastax.spark.connector.writer.WriteConf;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.spark.SparkConf;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple11;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class WriteConf$
implements Serializable {
    public static final WriteConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<ConsistencyLevel> ConsistencyLevelParam;
    private final ConfigParameter<Option<Object>> BatchSizeRowsParam;
    private final ConfigParameter<Object> BatchSizeBytesParam;
    private final ConfigParameter<Object> BatchBufferSizeParam;
    private final ConfigParameter<BatchGroupingKey> BatchLevelParam;
    private final ConfigParameter<Object> IfNotExistsParam;
    private final ConfigParameter<Object> IgnoreNullsParam;
    private final ConfigParameter<Object> ParallelismLevelParam;
    private final ConfigParameter<Object> ThroughputMiBPSParam;
    private final ConfigParameter<Object> TTLParam;
    private final ConfigParameter<Object> TaskMetricsParam;
    private final Set<ConfigParameter<?>> Properties;

    static {
        new WriteConf$();
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<ConsistencyLevel> ConsistencyLevelParam() {
        return this.ConsistencyLevelParam;
    }

    public ConfigParameter<Option<Object>> BatchSizeRowsParam() {
        return this.BatchSizeRowsParam;
    }

    public ConfigParameter<Object> BatchSizeBytesParam() {
        return this.BatchSizeBytesParam;
    }

    public ConfigParameter<Object> BatchBufferSizeParam() {
        return this.BatchBufferSizeParam;
    }

    public ConfigParameter<BatchGroupingKey> BatchLevelParam() {
        return this.BatchLevelParam;
    }

    public ConfigParameter<Object> IfNotExistsParam() {
        return this.IfNotExistsParam;
    }

    public ConfigParameter<Object> IgnoreNullsParam() {
        return this.IgnoreNullsParam;
    }

    public ConfigParameter<Object> ParallelismLevelParam() {
        return this.ParallelismLevelParam;
    }

    public ConfigParameter<Object> ThroughputMiBPSParam() {
        return this.ThroughputMiBPSParam;
    }

    public ConfigParameter<Object> TTLParam() {
        return this.TTLParam;
    }

    public ConfigParameter<Object> TaskMetricsParam() {
        return this.TaskMetricsParam;
    }

    public Set<ConfigParameter<?>> Properties() {
        return this.Properties;
    }

    public WriteConf fromSparkConf(SparkConf conf) {
        String string;
        block4: {
            Product product;
            boolean ignoreNulls;
            boolean ifNotExists;
            ConsistencyLevel consistencyLevel;
            block3: {
                Regex Number2;
                block2: {
                    ConfigCheck$.MODULE$.checkConfig(conf);
                    int batchSizeInBytes = conf.getInt(this.BatchSizeBytesParam().name(), BoxesRunTime.unboxToInt((Object)this.BatchSizeBytesParam().default()));
                    consistencyLevel = ConsistencyLevel.valueOf(conf.get(this.ConsistencyLevelParam().name(), ((Enum)this.ConsistencyLevelParam().default()).name()));
                    String batchSizeInRowsStr = conf.get(this.BatchSizeRowsParam().name(), "auto");
                    ifNotExists = conf.getBoolean(this.IfNotExistsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default()));
                    ignoreNulls = conf.getBoolean(this.IgnoreNullsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default()));
                    Number2 = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)")).r();
                    String string2 = string = batchSizeInRowsStr;
                    if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block2;
                    product = new BytesInBatch(batchSizeInBytes);
                    break block3;
                }
                Option option = Number2.unapplySeq((Object)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                product = new RowsInBatch(new StringOps(Predef$.MODULE$.augmentString(x)).toInt());
            }
            BytesInBatch batchSize = product;
            int batchBufferSize = conf.getInt(this.BatchBufferSizeParam().name(), BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default()));
            BatchGroupingKey batchGroupingKey = (BatchGroupingKey)conf.getOption(this.BatchLevelParam().name()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BatchGroupingKey apply(String name) {
                    return BatchGroupingKey$.MODULE$.apply(name);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BatchGroupingKey apply() {
                    return WriteConf$.MODULE$.BatchLevelParam().default();
                }
            });
            int parallelismLevel = conf.getInt(this.ParallelismLevelParam().name(), BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default()));
            double throughputMiBPS = conf.getDouble(this.ThroughputMiBPSParam().name(), BoxesRunTime.unboxToDouble((Object)this.ThroughputMiBPSParam().default()));
            boolean metricsEnabled = conf.getBoolean(this.TaskMetricsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default()));
            int ttlSeconds = conf.getInt(this.TTLParam().name(), BoxesRunTime.unboxToInt((Object)this.TTLParam().default()));
            TTLOption ttlOption = ttlSeconds == BoxesRunTime.unboxToInt((Object)this.TTLParam().default()) ? TTLOption$.MODULE$.defaultValue() : TTLOption$.MODULE$.constant(ttlSeconds);
            BytesInBatch x$1 = batchSize;
            int x$2 = batchBufferSize;
            BatchGroupingKey x$3 = batchGroupingKey;
            ConsistencyLevel x$4 = consistencyLevel;
            int x$5 = parallelismLevel;
            double x$6 = throughputMiBPS;
            boolean x$7 = metricsEnabled;
            TTLOption x$8 = ttlOption;
            boolean x$9 = ignoreNulls;
            boolean x$10 = ifNotExists;
            TimestampOption x$11 = this.apply$default$10();
            return new WriteConf(x$1, x$2, x$3, x$4, x$10, x$9, x$5, x$6, x$8, x$11, x$7);
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value of spark.cassandra.output.batch.size.rows: ", ". Number or 'auto' expected"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public WriteConf apply(BatchSize batchSize, int batchGroupingBufferSize, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, boolean ifNotExists, boolean ignoreNulls, int parallelismLevel, double throughputMiBPS, TTLOption ttl, TimestampOption timestamp, boolean taskMetricsEnabled) {
        return new WriteConf(batchSize, batchGroupingBufferSize, batchGroupingKey, consistencyLevel, ifNotExists, ignoreNulls, parallelismLevel, throughputMiBPS, ttl, timestamp, taskMetricsEnabled);
    }

    public Option<Tuple11<BatchSize, Object, BatchGroupingKey, ConsistencyLevel, Object, Object, Object, Object, TTLOption, TimestampOption, Object>> unapply(WriteConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.batchSize(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGroupingBufferSize()), (Object)x$0.batchGroupingKey(), (Object)x$0.consistencyLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ifNotExists()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreNulls()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelismLevel()), (Object)BoxesRunTime.boxToDouble((double)x$0.throughputMiBPS()), (Object)x$0.ttl(), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.taskMetricsEnabled())));
    }

    public BatchSize $lessinit$greater$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public int $lessinit$greater$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default());
    }

    public BatchGroupingKey $lessinit$greater$default$3() {
        return this.BatchLevelParam().default();
    }

    public ConsistencyLevel $lessinit$greater$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default());
    }

    public boolean $lessinit$greater$default$6() {
        return BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default());
    }

    public int $lessinit$greater$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public double $lessinit$greater$default$8() {
        return BoxesRunTime.unboxToDouble((Object)this.ThroughputMiBPSParam().default());
    }

    public TTLOption $lessinit$greater$default$9() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public TimestampOption $lessinit$greater$default$10() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean $lessinit$greater$default$11() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default());
    }

    public BatchSize apply$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default());
    }

    public BatchGroupingKey apply$default$3() {
        return this.BatchLevelParam().default();
    }

    public ConsistencyLevel apply$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean apply$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default());
    }

    public boolean apply$default$6() {
        return BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public double apply$default$8() {
        return BoxesRunTime.unboxToDouble((Object)this.ThroughputMiBPSParam().default());
    }

    public TTLOption apply$default$9() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public TimestampOption apply$default$10() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean apply$default$11() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private WriteConf$() {
        MODULE$ = this;
        this.ReferenceSection = "Write Tuning Parameters";
        this.ConsistencyLevelParam = new ConfigParameter<ConsistencyLevel>("spark.cassandra.output.consistency.level", this.ReferenceSection(), ConsistencyLevel.LOCAL_QUORUM, "Consistency level for writing");
        this.BatchSizeRowsParam = new ConfigParameter<None$>("spark.cassandra.output.batch.size.rows", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Number of rows per single batch. The default is 'auto'\n      |which means the connector will adjust the number\n      |of rows based on the amount of data\n      |in each row")).stripMargin());
        this.BatchSizeBytesParam = new ConfigParameter<Integer>("spark.cassandra.output.batch.size.bytes", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1024), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum total size of the batch in bytes. Overridden by\n      |", "\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BatchSizeRowsParam().name()})))).stripMargin());
        this.BatchBufferSizeParam = new ConfigParameter<Integer>("spark.cassandra.output.batch.grouping.buffer.size", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), new StringOps(Predef$.MODULE$.augmentString(" How many batches per single Spark task can be stored in\n      |memory before sending to Cassandra")).stripMargin());
        this.BatchLevelParam = new ConfigParameter<BatchGroupingKey$Partition$>("spark.cassandra.output.batch.grouping.key", this.ReferenceSection(), BatchGroupingKey$Partition$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Determines how insert statements are grouped into batches. Available values are\n    |<ul>\n    |  <li> <code> none </code> : a batch may contain any statements </li>\n    |  <li> <code> replica_set </code> : a batch may contain only statements to be written to the same replica set </li>\n    |  <li> <code> partition </code> : a batch may contain only statements for rows sharing the same partition key value </li>\n    |</ul>\n    |")).stripMargin());
        this.IfNotExistsParam = new ConfigParameter<Boolean>("spark.cassandra.output.ifNotExists", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString("Determines that the INSERT operation is not performed if a row with the same primary\n\t\t\t\t|key already exists. Using the feature incurs a performance hit.")).stripMargin());
        this.IgnoreNullsParam = new ConfigParameter<Boolean>("spark.cassandra.output.ignoreNulls", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString(" In Cassandra >= 2.2 null values can be left as unset in bound statements. Setting\n        |this to true will cause all null values to be left as unset rather than bound. For\n        |finer control see the CassandraOption class")).stripMargin());
        this.ParallelismLevelParam = new ConfigParameter<Integer>("spark.cassandra.output.concurrent.writes", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)5), new StringOps(Predef$.MODULE$.augmentString("Maximum number of batches executed in parallel by a\n      | single Spark task")).stripMargin());
        this.ThroughputMiBPSParam = new ConfigParameter<Double>("spark.cassandra.output.throughput_mb_per_sec", this.ReferenceSection(), BoxesRunTime.boxToDouble((double)2.147483647E9), new StringOps(Predef$.MODULE$.augmentString("*(Floating points allowed)* <br> Maximum write throughput allowed\n      | per single core in MB/s. <br> Limit this on long (+8 hour) runs to 70% of your max throughput\n      | as seen on a smaller job for stability")).stripMargin());
        this.TTLParam = new ConfigParameter<Integer>("spark.cassandra.output.ttl", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)0), new StringOps(Predef$.MODULE$.augmentString("Time To Live(TTL) assigned to writes to Cassandra. A value of 0 means no TTL")).stripMargin());
        this.TaskMetricsParam = new ConfigParameter<Boolean>("spark.cassandra.output.metrics", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)true), "Sets whether to record connector specific metrics on write");
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.BatchSizeBytesParam(), this.ConsistencyLevelParam(), this.BatchSizeRowsParam(), this.BatchBufferSizeParam(), this.BatchLevelParam(), this.IfNotExistsParam(), this.IgnoreNullsParam(), this.ParallelismLevelParam(), this.ThroughputMiBPSParam(), this.TTLParam(), this.TaskMetricsParam()}));
    }
}

