/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tq\u0011i\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033}i\u0011A\u0007\u0006\u0003\u000fmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001E\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003O\u0011\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0005uC\ndW\rR3g!\t\u00193&\u0003\u0002-I\tAA+\u00192mK\u0012+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00039\u0019w\u000e\\;n]N+G.Z2u_J\u00042\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003iE\u0012!\"\u00138eKb,GmU3r!\t1t'D\u0001\u0005\u0013\tADAA\u0005D_2,XN\u001c*fM\"A!\b\u0001B\u0001B\u0003%1(A\u0005s_^<&/\u001b;feB\u0019A(P \u000e\u0003\tI!A\u0010\u0002\u0003\u0013I{wo\u0016:ji\u0016\u0014\bC\u0001!B\u0019\u0001!QA\u0011\u0001C\u0002\r\u0013\u0011\u0001V\t\u0003\t\u001e\u0003\"\u0001E#\n\u0005\u0019\u000b\"a\u0002(pi\"Lgn\u001a\t\u0003!!K!!S\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003%9(/\u001b;f\u0007>tg\r\u0005\u0002=\u001b&\u0011aJ\u0001\u0002\n/JLG/Z\"p]\u001aDQ\u0001\u0015\u0001\u0005\nE\u000ba\u0001P5oSRtDC\u0002*T)V3v\u000bE\u0002=\u0001}BQ!B(A\u0002\tBQ!K(A\u0002)BQAL(A\u0002=BQAO(A\u0002mBQaS(A\u00021Cq!\u0017\u0001C\u0002\u0013\u0005!,\u0001\u0007lKf\u001c\b/Y2f\u001d\u0006lW-F\u0001\\!\tavL\u0004\u0002\u0011;&\u0011a,E\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_#!11\r\u0001Q\u0001\nm\u000bQb[3zgB\f7-\u001a(b[\u0016\u0004\u0003bB3\u0001\u0005\u0004%\tAW\u0001\ni\u0006\u0014G.\u001a(b[\u0016Daa\u001a\u0001!\u0002\u0013Y\u0016A\u0003;bE2,g*Y7fA!9\u0011\u000e\u0001b\u0001\n\u0003Q\u0017aC2pYVlgNT1nKN,\u0012a\u001b\t\u0004a1\\\u0016BA72\u0005\r\u0019V-\u001d\u0005\u0007_\u0002\u0001\u000b\u0011B6\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\t\u000fE\u0004!\u0019!C\u0001e\u000691m\u001c7v[:\u001cX#A:\u0011\u0007AbG\u000f\u0005\u0002$k&\u0011a\u000f\n\u0002\n\u0007>dW/\u001c8EK\u001aDa\u0001\u001f\u0001!\u0002\u0013\u0019\u0018\u0001C2pYVlgn\u001d\u0011\t\u0013i\u0004\u0001R1A\u0005\u0002\u0011Q\u0016\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\"AA\u0010\u0001E\u0001B\u0003&1,A\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<\u0017J\\:feR\u0004\u0003\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011\u0002.\u00021E,XM]=UK6\u0004H.\u0019;f+NLgnZ+qI\u0006$X\rC\u0005\u0002\u0002\u0001A\t\u0011)Q\u00057\u0006I\u0012/^3ssR+W\u000e\u001d7bi\u0016,6/\u001b8h+B$\u0017\r^3!\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9!A\bjg\u000e{WO\u001c;feV\u0003H-\u0019;f+\t\tI\u0001E\u0002\u0011\u0003\u0017I1!!\u0004\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0005\u0001A\u0003%\u0011\u0011B\u0001\u0011SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uK\u0002B\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0002\u00027\r|g\u000e^1j]N\u001cu\u000e\u001c7fGRLwN\u001c\"fQ\u00064\u0018n\u001c:t\u0011!\tI\u0002\u0001Q\u0001\n\u0005%\u0011\u0001H2p]R\f\u0017N\\:D_2dWm\u0019;j_:\u0014U\r[1wS>\u00148\u000f\t\u0005\t\u0003;\u0001!\u0019!C\u00055\u0006i\u0011/^3ssR+W\u000e\u001d7bi\u0016Dq!!\t\u0001A\u0003%1,\u0001\brk\u0016\u0014\u0018\u0010V3na2\fG/\u001a\u0011\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(\u0005\u0001\u0002O]3qCJ,7\u000b^1uK6,g\u000e\u001e\u000b\u0005\u0003S\tI\u0004\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\t\r|'/\u001a\u0006\u0004\u0003gA\u0011A\u00023sSZ,'/\u0003\u0003\u00028\u00055\"!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"A\u00111HA\u0012\u0001\u0004\ti$A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005-\u0012qH\u0005\u0005\u0003\u0003\niCA\u0004TKN\u001c\u0018n\u001c8\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005y!-\u0019;dQJ{W\u000f^5oO.+\u0017\u0010\u0006\u0004\u0002J\u0005U\u0013q\u000b\u000b\u0004\u000f\u0006-\u0003\u0002CA'\u0003\u0007\u0002\r!a\u0014\u0002\u0005\t\u001c\b\u0003BA\u0016\u0003#JA!a\u0015\u0002.\tq!i\\;oIN#\u0018\r^3nK:$\b\u0002CA\u001e\u0003\u0007\u0002\r!!\u0010\t\u0011\u0005e\u00131\ta\u0001\u00037\n1C]8vi&twmS3z\u000f\u0016tWM]1u_J\u00042\u0001PA/\u0013\r\tyF\u0001\u0002\u0014%>,H/\u001b8h\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0005\b\u0003G\u0002A\u0011AA3\u0003\u00159(/\u001b;f)\u0019\t9'!\u001c\u0002xA\u0019\u0001#!\u001b\n\u0007\u0005-\u0014C\u0001\u0003V]&$\b\u0002CA8\u0003C\u0002\r!!\u001d\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u00043\u0005M\u0014bAA;5\tYA+Y:l\u0007>tG/\u001a=u\u0011!\tI(!\u0019A\u0002\u0005m\u0014\u0001\u00023bi\u0006\u0004B\u0001MA?\u007f%\u0019\u0011qP\u0019\u0003\u0011%#XM]1u_J<q!a!\u0003\u0011\u0003\t))A\u0006UC\ndWm\u0016:ji\u0016\u0014\bc\u0001\u001f\u0002\b\u001a1\u0011A\u0001E\u0001\u0003\u0013\u001bB!a\"\u0010+!9\u0001+a\"\u0005\u0002\u00055ECAAC\u0011!\t\t*a\"\u0005\n\u0005M\u0015aE2iK\u000e\\W*[:tS:<7i\u001c7v[:\u001cHCBA4\u0003+\u000bI\nC\u0004\u0002\u0018\u0006=\u0005\u0019\u0001\u0016\u0002\u000bQ\f'\r\\3\t\r%\fy\t1\u0001l\u0011!\ti*a\"\u0005\n\u0005}\u0015!H2iK\u000e\\W*[:tS:<\u0007K]5nCJL8*Z=D_2,XN\\:\u0015\r\u0005\u001d\u0014\u0011UAR\u0011\u001d\t9*a'A\u0002)Ba![AN\u0001\u0004Y\u0007\u0002CAT\u0003\u000f#I!!+\u00021\rDWmY6D_2dWm\u0019;j_:\u0014U\r[1wS>\u00148\u000f\u0006\u0004\u0002h\u0005-\u0016Q\u0016\u0005\b\u0003/\u000b)\u000b1\u0001+\u0011\u001d\ty+!*A\u0002=\n!bY8mk6t'+\u001a4t\u0011!\t\u0019,a\"\u0005\n\u0005U\u0016\u0001D2iK\u000e\\7i\u001c7v[:\u001cHCBA4\u0003o\u000bI\fC\u0004\u0002\u0018\u0006E\u0006\u0019\u0001\u0016\t\u000f\u0005=\u0016\u0011\u0017a\u0001_!A\u0011QXAD\t\u0003\ty,A\u0003baBd\u00170\u0006\u0003\u0002B\u0006%G\u0003DAb\u0003+\f9.!7\u0002\\\u0006\rH\u0003BAc\u0003\u0017\u0004B\u0001\u0010\u0001\u0002HB\u0019\u0001)!3\u0005\r\t\u000bYL1\u0001D\u0011)\ti-a/\u0002\u0002\u0003\u000f\u0011qZ\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#\u0002\u001f\u0002R\u0006\u001d\u0017bAAj\u0005\t\u0001\"k\\<Xe&$XM\u001d$bGR|'/\u001f\u0005\u0007\u000b\u0005m\u0006\u0019\u0001\u0012\t\re\u000bY\f1\u0001\\\u0011\u0019)\u00171\u0018a\u00017\"9\u0011.a/A\u0002\u0005u\u0007c\u0001\u001c\u0002`&\u0019\u0011\u0011\u001d\u0003\u0003\u001d\r{G.^7o'\u0016dWm\u0019;pe\"11*a/A\u00021C!\"a:\u0002\b\u0006\u0005I\u0011BAu\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\b\u0003BAw\u0003ol!!a<\u000b\t\u0005E\u00181_\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0006!!.\u0019<b\u0013\u0011\tI0a<\u0003\r=\u0013'.Z2u\u0001")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final TableDef com$datastax$spark$connector$writer$TableWriter$$tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    public final WriteConf com$datastax$spark$connector$writer$TableWriter$$writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private final String queryTemplate;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, rowWriterFactory);
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                WriteOptionValue<Object> writeOptionValue3;
                None$ none$2;
                WriteOptionValue<Object> writeOptionValue4;
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)":").append((Object)x$1).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                if (tTLOption != null && (writeOptionValue4 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue4;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (tTLOption != null && (writeOptionValue3 = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue3;
                    int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value2)})));
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ ttlSpec = none$2;
                TimestampOption timestampOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder3 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder3})));
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value3 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)value3)})));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ timestampSpec = none$;
                List options = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ttlSpec, timestampSpec})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                String optionsSpec = options.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.mkString(" AND ")})) : "";
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ") ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), columnSpec, valueSpec, ifNotExistsSpec, optionsSpec})).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new $anonfun$9(this));
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new $anonfun$10(this));
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1)new Serializable(this, nameToBehavior){
                    public static final long serialVersionUID = 0L;
                    private final Map nameToBehavior$1;

                    public final Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> apply(ColumnDef colDef) {
                        String name = colDef.columnName();
                        Option collectionBehavior = this.nameToBehavior$1.get((Object)name);
                        String quotedName = Quote$.MODULE$.quote(name);
                        return new Tuple4((Object)colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                    }
                    {
                        this.nameToBehavior$1 = nameToBehavior$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Unable to fully structure code
                     */
                    public final String apply(Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> x$6) {
                        block5: {
                            block10: {
                                block7: {
                                    block9: {
                                        block8: {
                                            block6: {
                                                var2_2 = x$6;
                                                if (var2_2 == null) break block5;
                                                collectionBehavior = (Option)var2_2._3();
                                                quotedName = (String)var2_2._4();
                                                var5_5 = false;
                                                var6_6 = null;
                                                var7_7 = collectionBehavior;
                                                if (!(var7_7 instanceof Some)) break block6;
                                                var5_5 = true;
                                                var6_6 = (Some)var7_7;
                                                var8_8 = (CollectionBehavior)var6_6.x();
                                                v0 = CollectionAppend$.MODULE$;
                                                var9_9 = var8_8;
                                                if (v0 != null ? v0.equals(var9_9) == false : var9_9 != null) break block6;
                                                var10_10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                                break block7;
                                            }
                                            if (!var5_5) break block8;
                                            var11_11 = (CollectionBehavior)var6_6.x();
                                            v1 = CollectionPrepend$.MODULE$;
                                            var12_12 = var11_11;
                                            if (v1 != null ? v1.equals(var12_12) == false : var12_12 != null) break block8;
                                            var10_10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", " + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                            break block7;
                                        }
                                        if (!var5_5) break block9;
                                        var13_13 = (CollectionBehavior)var6_6.x();
                                        v2 = CollectionRemove$.MODULE$;
                                        var14_14 = var13_13;
                                        if (v2 != null ? v2.equals(var14_14) == false : var14_14 != null) break block9;
                                        var10_10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " - :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                        break block7;
                                    }
                                    if (!(var7_7 instanceof Some)) ** GOTO lbl-1000
                                    var15_15 = (Some)var7_7;
                                    var16_16 = (CollectionBehavior)var15_15.x();
                                    v3 = CollectionOverwrite$.MODULE$;
                                    var17_17 = var16_16;
                                    if (!(v3 != null ? v3.equals(var17_17) == false : var17_17 != null)) {
                                        var18_18 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v4 = None$.MODULE$;
                                        var19_19 = var7_7;
                                        var18_18 = !(v4 != null ? v4.equals(var19_19) == false : var19_19 != null);
                                    }
                                    if (!var18_18) break block10;
                                    var10_10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName}));
                                }
                                var20_20 = var10_10;
                                return var20_20;
                            }
                            throw new MatchError((Object)var7_7);
                        }
                        throw new MatchError(var2_2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$1(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause2 = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), setClause, whereClause2}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    public boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() {
        return this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    private String queryTemplate() {
        return this.queryTemplate;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(Session session) {
        try {
            return session.prepare(this.queryTemplate());
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queryTemplate()}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    public Object batchRoutingKey(Session session, RoutingKeyGenerator routingKeyGenerator, BoundStatement bs) {
        BatchGroupingKey batchGroupingKey;
        block5: {
            Comparable<Integer> comparable;
            block3: {
                block4: {
                    block2: {
                        batchGroupingKey = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingKey();
                        BatchGroupingKey$None$ batchGroupingKey$None$ = BatchGroupingKey$None$.MODULE$;
                        BatchGroupingKey batchGroupingKey2 = batchGroupingKey;
                        if (batchGroupingKey$None$ != null ? !batchGroupingKey$None$.equals(batchGroupingKey2) : batchGroupingKey2 != null) break block2;
                        comparable = BoxesRunTime.boxToInteger((int)0);
                        break block3;
                    }
                    BatchGroupingKey$ReplicaSet$ batchGroupingKey$ReplicaSet$ = BatchGroupingKey$ReplicaSet$.MODULE$;
                    BatchGroupingKey batchGroupingKey3 = batchGroupingKey;
                    if (batchGroupingKey$ReplicaSet$ != null ? !batchGroupingKey$ReplicaSet$.equals(batchGroupingKey3) : batchGroupingKey3 != null) break block4;
                    Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                    comparable = BoxesRunTime.boxToInteger((int)((Object)session.getCluster().getMetadata().getReplicas(this.keyspaceName(), bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE))).hashCode());
                    break block3;
                }
                BatchGroupingKey$Partition$ batchGroupingKey$Partition$ = BatchGroupingKey$Partition$.MODULE$;
                BatchGroupingKey batchGroupingKey4 = batchGroupingKey;
                if (batchGroupingKey$Partition$ != null ? !batchGroupingKey$Partition$.equals(batchGroupingKey4) : batchGroupingKey4 != null) break block5;
                Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                comparable = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE).duplicate();
            }
            return comparable;
        }
        throw new MatchError((Object)batchGroupingKey);
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.com$datastax$spark$connector$writer$TableWriter$$writeConf);
        this.connector.withSessionDo(new Serializable(this, data, updater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final Iterator data$1;
            public final OutputMetricsUpdater updater$1;

            public final void apply(Session session) {
                ProtocolVersion protocolVersion2 = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
                CountingIterator<T> rowIterator = new CountingIterator<T>(this.data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
                PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(session).setConsistencyLevel(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                QueryExecutor queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final void apply(RichStatement x$10, long x$11, long x$12) {
                        this.$outer.updater$1.batchFinished(true, x$10, x$11, x$12);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final void apply(RichStatement x$13, long x$14, long x$15) {
                        this.$outer.updater$1.batchFinished(false, x$13, x$14, x$15);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator(this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef, this.$outer.columnNames());
                BatchStatement.Type batchType = this.$outer.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? BatchStatement.Type.COUNTER : BatchStatement.Type.UNLOGGED;
                RowWriter<T> x$26 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter;
                PreparedStatement x$27 = stmt;
                ProtocolVersion x$28 = protocolVersion2;
                boolean x$29 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.ignoreNulls();
                Seq<Object> x$30 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
                BoundStatementBuilder<T> boundStmtBuilder = new BoundStatementBuilder<T>(x$26, x$27, x$30, x$29, x$28);
                BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder(batchType, routingKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                Serializable batchKeyGenerator = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;
                    private final Session session$1;
                    private final RoutingKeyGenerator routingKeyGenerator$1;

                    public final Object apply(BoundStatement bs) {
                        return this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().batchRoutingKey(this.session$1, this.routingKeyGenerator$1, bs);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.session$1 = session$1;
                        this.routingKeyGenerator$1 = routingKeyGenerator$1;
                    }
                };
                GroupingBatchBuilder<T> batchBuilder = new GroupingBatchBuilder<T>(boundStmtBuilder, batchStmtBuilder, (Function1<BoundStatement, Object>)batchKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingBufferSize(), rowIterator);
                RateLimiter rateLimiter = new RateLimiter((long)(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.throughputMiBPS() * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                batchBuilder.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final QueryExecutor queryExecutor$1;
                    private final RateLimiter rateLimiter$1;

                    public final void apply(RichStatement stmtToWrite) {
                        this.queryExecutor$1.executeAsync(stmtToWrite);
                        Predef$.MODULE$.assert(stmtToWrite.bytesCount() > 0);
                        this.rateLimiter$1.maybeSleep(stmtToWrite.bytesCount());
                    }
                    {
                        this.queryExecutor$1 = queryExecutor$1;
                        this.rateLimiter$1 = rateLimiter$1;
                    }
                });
                queryExecutor.waitForCurrentlyExecutingTasks();
                if (queryExecutor.successful()) {
                    double duration = (double)this.updater$1.finish() / 1.0E9;
                    this.$outer.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$write$1 $outer;
                        private final CountingIterator rowIterator$1;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$1 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                            String arg$2 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                            String arg$3 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                            double arg$4 = this.duration$1;
                            return new StringOps(Predef$.MODULE$.augmentString("Wrote %s rows to %s.%s in %.3f s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2, arg$3, BoxesRunTime.boxToDouble((double)arg$4)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rowIterator$1 = rowIterator$1;
                            this.duration$1 = duration$1;
                        }
                    });
                    if (boundStmtBuilder.logUnsetToNullWarning()) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, boundStmtBuilder){
                            public static final long serialVersionUID = 0L;
                            private final BoundStatementBuilder boundStmtBuilder$1;

                            public final String apply() {
                                return this.boundStmtBuilder$1.UnsetToNullWarning();
                            }
                            {
                                this.boundStmtBuilder$1 = boundStmtBuilder$1;
                            }
                        });
                    }
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write statements to ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.keyspaceName(), this.$outer.tableName()})));
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.data$1 = data$1;
                this.updater$1 = var3_3;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$7) {
                return x$7.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.com$datastax$spark$connector$writer$TableWriter$$writeConf = writeConf;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a Materialized View and Views are not writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate = tableDef.columns().exists((Function1)new $anonfun$15(this));
        this.containsCollectionBehaviors = columnSelector.exists((Function1)new $anonfun$16(this));
        this.queryTemplate = this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() || this.containsCollectionBehaviors() ? this.queryTemplateUsingUpdate() : this.queryTemplateUsingInsert();
    }
}

