/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.reader;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.reader.KeyValueRowReader;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\r9\u0011\u0001dS3z-\u0006dW/\u001a*poJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!\u0001\u0004sK\u0006$WM\u001d\u0006\u0003\u000b\u0019\t1A\u001d3e\u0015\t9\u0001\"A\u0005d_:tWm\u0019;pe*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002\u001b\u0005\u00191m\\7\u0016\u0007=y\"fE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007cA\f\u001955\t!!\u0003\u0002\u001a\u0005\t\u0001\"k\\<SK\u0006$WM\u001d$bGR|'/\u001f\t\u0005#mi\u0012&\u0003\u0002\u001d%\t1A+\u001e9mKJ\u0002\"AH\u0010\r\u0001\u0011)\u0001\u0005\u0001b\u0001E\t\t1j\u0001\u0001\u0012\u0005\r2\u0003CA\t%\u0013\t)#CA\u0004O_RD\u0017N\\4\u0011\u0005E9\u0013B\u0001\u0015\u0013\u0005\r\te.\u001f\t\u0003=)\"Qa\u000b\u0001C\u0002\t\u0012\u0011A\u0016\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005a1.Z=TK2,7\r^5p]B\u0011q\u0006M\u0007\u0002\r%\u0011\u0011G\u0002\u0002\u000f\u0007>dW/\u001c8TK2,7\r^8s\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014AB6fsJ\u0013f\tE\u0002\u00181uA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\tm\u0006dW/\u001a*S\rB\u0019q\u0003G\u0015\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\u0011YD(\u0010 \u0011\t]\u0001Q$\u000b\u0005\u0006[a\u0002\rA\f\u0005\u0006ga\u0002\r\u0001\u000e\u0005\u0006ma\u0002\ra\u000e\u0005\u0006\u0001\u0002!\t%Q\u0001\ne><(+Z1eKJ$2AQ#N!\r92IG\u0005\u0003\t\n\u0011\u0011BU8x%\u0016\fG-\u001a:\t\u000b\u0019{\u0004\u0019A$\u0002\u000bQ\f'\r\\3\u0011\u0005![U\"A%\u000b\u0005)3\u0011aA2rY&\u0011A*\u0013\u0002\t)\u0006\u0014G.\u001a#fM\")aj\u0010a\u0001\u001f\u0006y1m\u001c7v[:\u001cV\r\\3di&|g\u000eE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Q\u000b\u0013A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t9&#A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&AC%oI\u0016DX\rZ*fc*\u0011qK\u0005\t\u0003_qK!!\u0018\u0004\u0003\u0013\r{G.^7o%\u00164\u0007\"B0\u0001\t\u0003\u0002\u0017a\u0003;be\u001e,Go\u00117bgN,\u0012!\u0019\t\u0004E\u0016TbBA\td\u0013\t!'#\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014Qa\u00117bgNT!\u0001\u001a\n")
public class KeyValueRowReaderFactory<K, V>
implements RowReaderFactory<Tuple2<K, V>> {
    private final ColumnSelector keySelection;
    private final RowReaderFactory<K> keyRRF;
    private final RowReaderFactory<V> valueRRF;

    @Override
    public RowReader<Tuple2<K, V>> rowReader(TableDef table, IndexedSeq<ColumnRef> columnSelection) {
        RowReader<K> keyReader = this.keyRRF.rowReader(table, this.keySelection.selectFrom(table));
        RowReader<V> valueReader = this.valueRRF.rowReader(table, columnSelection);
        return new KeyValueRowReader<K, V>(keyReader, valueReader);
    }

    @Override
    public Class<Tuple2<K, V>> targetClass() {
        return Tuple2.class;
    }

    public KeyValueRowReaderFactory(ColumnSelector keySelection, RowReaderFactory<K> keyRRF, RowReaderFactory<V> valueRRF) {
        this.keySelection = keySelection;
        this.keyRRF = keyRRF;
        this.valueRRF = valueRRF;
    }
}

