/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.schemabuilder.StatementStart;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import shade.com.datastax.spark.connector.google.common.base.Strings;

public abstract class SchemaStatement
extends RegularStatement {
    static final String STATEMENT_START = "\n\t";
    static final String COLUMN_FORMATTING = "\n\t\t";
    static final List<String> RESERVED_KEYWORDS = Arrays.asList("add,allow,alter,and,any,apply,asc,authorize,batch,begin,by,columnfamily,create,delete,desc,drop,each_quorum,from,grant,in,index,inet,infinity,insert,into,keyspace,keyspaces,limit,local_one,local_quorum,modify,nan,norecursive,of,on,order,password,primary,quorum,rename,revoke,schema,select,set,table,three,to,token,truncate,two,unlogged,update,use,using,where,with".split(","));
    private volatile String cache;

    abstract String buildInternal();

    @Override
    public String getQueryString(CodecRegistry codecRegistry) {
        if (this.cache == null) {
            this.cache = this.buildInternal();
        }
        return this.cache;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        return new ByteBuffer[0];
    }

    @Override
    public boolean hasValues(CodecRegistry codecRegistry) {
        return false;
    }

    @Override
    public Map<String, ByteBuffer> getNamedValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        return null;
    }

    @Override
    public boolean usesNamedValues() {
        return false;
    }

    @Override
    public String getKeyspace() {
        return null;
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        return null;
    }

    static void validateNotEmpty(String columnName2, String label) {
        if (Strings.isNullOrEmpty(columnName2)) {
            throw new IllegalArgumentException(label + " should not be null or blank");
        }
    }

    static void validateNotNull(Object value2, String label) {
        if (value2 == null) {
            throw new IllegalArgumentException(label + " should not be null");
        }
    }

    static void validateNotKeyWord(String label, String message) {
        if (RESERVED_KEYWORDS.contains(label)) {
            throw new IllegalArgumentException(message);
        }
    }

    static SchemaStatement fromQueryString(final String queryString) {
        return new SchemaStatement(){

            @Override
            public String buildInternal() {
                return queryString;
            }
        };
    }

    StatementStart asStatementStart() {
        return new StatementStart(){

            @Override
            public String buildInternal() {
                return SchemaStatement.this.buildInternal();
            }
        };
    }
}

