/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import shade.com.datastax.spark.connector.google.common.base.Predicate;
import shade.com.datastax.spark.connector.google.common.base.Predicates;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;

public class HostFilterPolicy
implements ChainableLoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private final Predicate<Host> predicate;

    public HostFilterPolicy(LoadBalancingPolicy childPolicy, Predicate<Host> predicate2) {
        this.childPolicy = childPolicy;
        this.predicate = predicate2;
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts2) {
        ArrayList<Host> whiteHosts = new ArrayList<Host>(hosts2.size());
        for (Host host : hosts2) {
            if (!this.predicate.apply(host)) continue;
            whiteHosts.add(host);
        }
        if (whiteHosts.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot use HostFilterPolicy where the filter allows none of the contacts points (%s)", hosts2));
        }
        this.childPolicy.init(cluster, whiteHosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.predicate.apply(host) ? this.childPolicy.distance(host) : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        return this.childPolicy.newQueryPlan(loggedKeyspace, statement);
    }

    @Override
    public void onUp(Host host) {
        if (this.predicate.apply(host)) {
            this.childPolicy.onUp(host);
        }
    }

    @Override
    public void onDown(Host host) {
        if (this.predicate.apply(host)) {
            this.childPolicy.onDown(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        if (this.predicate.apply(host)) {
            this.childPolicy.onAdd(host);
        }
    }

    @Override
    public void onRemove(Host host) {
        if (this.predicate.apply(host)) {
            this.childPolicy.onRemove(host);
        }
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }

    public static HostFilterPolicy fromDCWhiteList(LoadBalancingPolicy childPolicy, Iterable<String> dcs2) {
        return new HostFilterPolicy(childPolicy, HostFilterPolicy.hostDCPredicate(dcs2, true));
    }

    public static HostFilterPolicy fromDCBlackList(LoadBalancingPolicy childPolicy, Iterable<String> dcs2) {
        return new HostFilterPolicy(childPolicy, Predicates.not(HostFilterPolicy.hostDCPredicate(dcs2, false)));
    }

    private static Predicate<Host> hostDCPredicate(Iterable<String> dcs2, final boolean includeNullDC) {
        final ImmutableSet<String> _dcs = ImmutableSet.copyOf(dcs2);
        return new Predicate<Host>(){

            @Override
            public boolean apply(Host host) {
                String hdc = host.getDatacenter();
                return hdc == null ? includeNullDC : _dcs.contains(hdc);
            }
        };
    }
}

