/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.utils.Bytes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;

class DataTypeClassNameParser {
    private static final Logger logger = LoggerFactory.getLogger(DataTypeClassNameParser.class);
    private static final String REVERSED_TYPE = "org.apache.cassandra.db.marshal.ReversedType";
    private static final String FROZEN_TYPE = "org.apache.cassandra.db.marshal.FrozenType";
    private static final String COMPOSITE_TYPE = "org.apache.cassandra.db.marshal.CompositeType";
    private static final String COLLECTION_TYPE = "org.apache.cassandra.db.marshal.ColumnToCollectionType";
    private static final String LIST_TYPE = "org.apache.cassandra.db.marshal.ListType";
    private static final String SET_TYPE = "org.apache.cassandra.db.marshal.SetType";
    private static final String MAP_TYPE = "org.apache.cassandra.db.marshal.MapType";
    private static final String UDT_TYPE = "org.apache.cassandra.db.marshal.UserType";
    private static final String TUPLE_TYPE = "org.apache.cassandra.db.marshal.TupleType";
    private static ImmutableMap<String, DataType> cassTypeToDataType = new ImmutableMap.Builder<String, DataType>().put("org.apache.cassandra.db.marshal.AsciiType", DataType.ascii()).put("org.apache.cassandra.db.marshal.LongType", DataType.bigint()).put("org.apache.cassandra.db.marshal.BytesType", DataType.blob()).put("org.apache.cassandra.db.marshal.BooleanType", DataType.cboolean()).put("org.apache.cassandra.db.marshal.CounterColumnType", DataType.counter()).put("org.apache.cassandra.db.marshal.DecimalType", DataType.decimal()).put("org.apache.cassandra.db.marshal.DoubleType", DataType.cdouble()).put("org.apache.cassandra.db.marshal.FloatType", DataType.cfloat()).put("org.apache.cassandra.db.marshal.InetAddressType", DataType.inet()).put("org.apache.cassandra.db.marshal.Int32Type", DataType.cint()).put("org.apache.cassandra.db.marshal.UTF8Type", DataType.text()).put("org.apache.cassandra.db.marshal.TimestampType", DataType.timestamp()).put("org.apache.cassandra.db.marshal.SimpleDateType", DataType.date()).put("org.apache.cassandra.db.marshal.TimeType", DataType.time()).put("org.apache.cassandra.db.marshal.UUIDType", DataType.uuid()).put("org.apache.cassandra.db.marshal.IntegerType", DataType.varint()).put("org.apache.cassandra.db.marshal.TimeUUIDType", DataType.timeuuid()).put("org.apache.cassandra.db.marshal.ByteType", DataType.tinyint()).put("org.apache.cassandra.db.marshal.ShortType", DataType.smallint()).build();

    DataTypeClassNameParser() {
    }

    static DataType parseOne(String className, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        boolean frozen = false;
        if (DataTypeClassNameParser.isReversed(className)) {
            className = DataTypeClassNameParser.getNestedClassName(className);
        } else if (DataTypeClassNameParser.isFrozen(className)) {
            frozen = true;
            className = DataTypeClassNameParser.getNestedClassName(className);
        }
        Parser parser = new Parser(className, 0);
        String next2 = parser.parseNextName();
        if (next2.startsWith(LIST_TYPE)) {
            return DataType.list(DataTypeClassNameParser.parseOne(parser.getTypeParameters().get(0), protocolVersion2, codecRegistry), frozen);
        }
        if (next2.startsWith(SET_TYPE)) {
            return DataType.set(DataTypeClassNameParser.parseOne(parser.getTypeParameters().get(0), protocolVersion2, codecRegistry), frozen);
        }
        if (next2.startsWith(MAP_TYPE)) {
            List<String> params = parser.getTypeParameters();
            return DataType.map(DataTypeClassNameParser.parseOne(params.get(0), protocolVersion2, codecRegistry), DataTypeClassNameParser.parseOne(params.get(1), protocolVersion2, codecRegistry), frozen);
        }
        if (frozen) {
            logger.warn("Got o.a.c.db.marshal.FrozenType for something else than a collection, this driver version might be too old for your version of Cassandra");
        }
        if (DataTypeClassNameParser.isUserType(next2)) {
            ++parser.idx;
            String keyspace = parser.readOne();
            parser.skipBlankAndComma();
            String typeName = TypeCodec.varchar().deserialize(Bytes.fromHexString("0x" + parser.readOne()), protocolVersion2);
            parser.skipBlankAndComma();
            Map<String, String> rawFields = parser.getNameAndTypeParameters();
            ArrayList<UserType.Field> fields2 = new ArrayList<UserType.Field>(rawFields.size());
            for (Map.Entry<String, String> entry : rawFields.entrySet()) {
                fields2.add(new UserType.Field(entry.getKey(), DataTypeClassNameParser.parseOne(entry.getValue(), protocolVersion2, codecRegistry)));
            }
            return new UserType(keyspace, typeName, fields2, protocolVersion2, codecRegistry);
        }
        if (DataTypeClassNameParser.isTupleType(next2)) {
            List<String> rawTypes = parser.getTypeParameters();
            ArrayList<DataType> types = new ArrayList<DataType>(rawTypes.size());
            for (String rawType : rawTypes) {
                types.add(DataTypeClassNameParser.parseOne(rawType, protocolVersion2, codecRegistry));
            }
            return new TupleType(types, protocolVersion2, codecRegistry);
        }
        DataType type = cassTypeToDataType.get(next2);
        return type == null ? DataType.custom(className) : type;
    }

    public static boolean isReversed(String className) {
        return className.startsWith(REVERSED_TYPE);
    }

    public static boolean isFrozen(String className) {
        return className.startsWith(FROZEN_TYPE);
    }

    private static String getNestedClassName(String className) {
        Parser p = new Parser(className, 0);
        p.parseNextName();
        List<String> l = p.getTypeParameters();
        if (l.size() != 1) {
            throw new IllegalStateException();
        }
        className = l.get(0);
        return className;
    }

    public static boolean isUserType(String className) {
        return className.startsWith(UDT_TYPE);
    }

    public static boolean isTupleType(String className) {
        return className.startsWith(TUPLE_TYPE);
    }

    private static boolean isComposite(String className) {
        return className.startsWith(COMPOSITE_TYPE);
    }

    private static boolean isCollection(String className) {
        return className.startsWith(COLLECTION_TYPE);
    }

    static ParseResult parseWithComposite(String className, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        Parser parser = new Parser(className, 0);
        String next2 = parser.parseNextName();
        if (!DataTypeClassNameParser.isComposite(next2)) {
            return new ParseResult(DataTypeClassNameParser.parseOne(className, protocolVersion2, codecRegistry), DataTypeClassNameParser.isReversed(next2));
        }
        List<String> subClassNames = parser.getTypeParameters();
        int count = subClassNames.size();
        String last = subClassNames.get(count - 1);
        HashMap<String, DataType> collections = new HashMap<String, DataType>();
        if (DataTypeClassNameParser.isCollection(last)) {
            --count;
            Parser collectionParser = new Parser(last, 0);
            collectionParser.parseNextName();
            Map<String, String> params = collectionParser.getCollectionsParameters();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                collections.put(entry.getKey(), DataTypeClassNameParser.parseOne(entry.getValue(), protocolVersion2, codecRegistry));
            }
        }
        ArrayList<DataType> types = new ArrayList<DataType>(count);
        ArrayList<Boolean> reversed = new ArrayList<Boolean>(count);
        for (int i = 0; i < count; ++i) {
            types.add(DataTypeClassNameParser.parseOne(subClassNames.get(i), protocolVersion2, codecRegistry));
            reversed.add(DataTypeClassNameParser.isReversed(subClassNames.get(i)));
        }
        return new ParseResult(true, types, reversed, collections);
    }

    private static class Parser {
        private final String str;
        private int idx;

        private Parser(String str2, int idx) {
            this.str = str2;
            this.idx = idx;
        }

        public String parseNextName() {
            this.skipBlank();
            return this.readNextIdentifier();
        }

        public String readOne() {
            String name = this.parseNextName();
            String args = this.readRawArguments();
            return name + args;
        }

        private String readRawArguments() {
            this.skipBlank();
            if (this.isEOS() || this.str.charAt(this.idx) == ')' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '(' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed parenthesis");
                }
                if (this.str.charAt(this.idx) == '(') {
                    ++open;
                    continue;
                }
                if (this.str.charAt(this.idx) != ')') continue;
                --open;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        public List<String> getTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return list;
                }
                try {
                    list.add(this.readOne());
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        public Map<String, String> getCollectionsParameters() {
            if (this.isEOS()) {
                return Collections.emptyMap();
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            return this.getNameAndTypeParameters();
        }

        public Map<String, String> getNameAndTypeParameters() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return map;
                }
                String bbHex = this.readNextIdentifier();
                String name = null;
                try {
                    name = TypeCodec.varchar().deserialize(Bytes.fromHexString("0x" + bbHex), ProtocolVersion.NEWEST_SUPPORTED);
                }
                catch (NumberFormatException e) {
                    this.throwSyntaxError(e.getMessage());
                }
                this.skipBlank();
                if (this.str.charAt(this.idx) != ':') {
                    this.throwSyntaxError("expecting ':' token");
                }
                ++this.idx;
                this.skipBlank();
                try {
                    map.put(name, this.readOne());
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private void throwSyntaxError(String msg) {
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
        }

        private boolean isEOS() {
            return Parser.isEOS(this.str, this.idx);
        }

        private static boolean isEOS(String str2, int i) {
            return i >= str2.length();
        }

        private void skipBlank() {
            this.idx = Parser.skipBlank(this.str, this.idx);
        }

        private static int skipBlank(String str2, int i) {
            while (!Parser.isEOS(str2, i) && ParseUtils.isBlank(str2.charAt(i))) {
                ++i;
            }
            return i;
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        public String readNextIdentifier() {
            int i = this.idx;
            while (!this.isEOS() && ParseUtils.isIdentifierChar(this.str.charAt(this.idx))) {
                ++this.idx;
            }
            return this.str.substring(i, this.idx);
        }

        public char readNextChar() {
            this.skipBlank();
            return this.str.charAt(this.idx++);
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }

    static class ParseResult {
        public final boolean isComposite;
        public final List<DataType> types;
        public final List<Boolean> reversed;
        public final Map<String, DataType> collections;

        private ParseResult(DataType type, boolean reversed) {
            this(false, Collections.singletonList(type), Collections.singletonList(reversed), Collections.emptyMap());
        }

        private ParseResult(boolean isComposite, List<DataType> types, List<Boolean> reversed, Map<String, DataType> collections) {
            this.isComposite = isComposite;
            this.types = types;
            this.reversed = reversed;
            this.collections = collections;
        }
    }
}

