/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(CachedConnectionProvider.class);
    private static final int VALIDITY_CHECK_TIMEOUT_S = 5;
    private final String url;
    private final String username;
    private final String password;
    private final int maxConnectionAttempts;
    private final long connectionRetryBackoff;
    private Connection connection;

    public CachedConnectionProvider(String url) {
        this(url, null, null);
    }

    public CachedConnectionProvider(String url, String username, String password) {
        this(url, username, password, 3, 10000L);
    }

    public CachedConnectionProvider(String url, String username, String password, int maxConnectionAttempts, long connectionRetryBackoff) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.maxConnectionAttempts = maxConnectionAttempts;
        this.connectionRetryBackoff = connectionRetryBackoff;
    }

    public synchronized Connection getValidConnection() {
        try {
            if (this.connection == null) {
                this.newConnection();
            } else if (!this.connection.isValid(5)) {
                log.info("The database connection is invalid. Reconnecting...");
                this.closeQuietly();
                this.newConnection();
            }
        }
        catch (SQLException sqle) {
            throw new ConnectException((Throwable)sqle);
        }
        return this.connection;
    }

    private void newConnection() throws SQLException {
        int attempts = 0;
        while (attempts < this.maxConnectionAttempts) {
            try {
                log.debug("Attempting to connect to {}", (Object)this.url);
                this.connection = DriverManager.getConnection(this.url, this.username, this.password);
                this.onConnect(this.connection);
                return;
            }
            catch (SQLException sqle) {
                if (++attempts < this.maxConnectionAttempts) {
                    log.info("Unable to connect to database on attempt {}/{}. Will retry in {} ms.", new Object[]{attempts, this.maxConnectionAttempts, this.connectionRetryBackoff, sqle});
                    try {
                        Thread.sleep(this.connectionRetryBackoff);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw sqle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeQuietly() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sqle) {
                log.warn("Ignoring error closing connection", (Throwable)sqle);
            }
            finally {
                this.connection = null;
            }
        }
    }

    protected void onConnect(Connection connection) throws SQLException {
    }
}

