/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.DataConverter;
import io.confluent.connect.jdbc.source.TableQuerier;
import io.confluent.connect.jdbc.util.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkTableQuerier
extends TableQuerier {
    private static final Logger log = LoggerFactory.getLogger(BulkTableQuerier.class);

    public BulkTableQuerier(TableQuerier.QueryMode mode, String name, String schemaPattern, String topicPrefix, boolean mapNumerics) {
        super(mode, name, topicPrefix, schemaPattern, mapNumerics);
    }

    @Override
    protected void createPreparedStatement(Connection db) throws SQLException {
        switch (this.mode) {
            case TABLE: {
                String quoteString = JdbcUtils.getIdentifierQuoteString(db);
                String queryString = "SELECT * FROM " + JdbcUtils.quoteString(this.name, quoteString);
                log.debug("{} prepared SQL query: {}", (Object)this, (Object)queryString);
                this.stmt = db.prepareStatement(queryString);
                break;
            }
            case QUERY: {
                log.debug("{} prepared SQL query: {}", (Object)this, (Object)this.query);
                this.stmt = db.prepareStatement(this.query);
                break;
            }
            default: {
                throw new ConnectException("Unknown mode: " + (Object)((Object)this.mode));
            }
        }
    }

    @Override
    protected ResultSet executeQuery() throws SQLException {
        return this.stmt.executeQuery();
    }

    @Override
    public SourceRecord extractRecord() throws SQLException {
        String topic;
        Map<String, String> partition;
        Struct record = DataConverter.convertRecord(this.schema, this.resultSet, this.mapNumerics);
        switch (this.mode) {
            case TABLE: {
                partition = Collections.singletonMap("table", this.name);
                topic = this.topicPrefix + this.name;
                break;
            }
            case QUERY: {
                partition = Collections.singletonMap("query", "query");
                topic = this.topicPrefix;
                break;
            }
            default: {
                throw new ConnectException("Unexpected query mode: " + (Object)((Object)this.mode));
            }
        }
        return new SourceRecord(partition, null, topic, record.schema(), (Object)record);
    }

    public String toString() {
        return "BulkTableQuerier{name='" + this.name + '\'' + ", query='" + this.query + '\'' + ", topicPrefix='" + this.topicPrefix + '\'' + '}';
    }
}

