/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class VerticaDialect
extends DbDialect {
    public VerticaDialect() {
        super("\"", "\"");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL(18," + parameters.get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "INT";
            }
            case INT16: {
                return "INT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "INT";
            }
            case FLOAT32: {
                return "FLOAT";
            }
            case FLOAT64: {
                return "FLOAT";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR(1024)";
            }
            case BYTES: {
                return "VARBINARY(1024)";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public List<String> getAlterTable(String tableName, Collection<SinkRecordField> fields) {
        ArrayList<String> queries = new ArrayList<String>(fields.size());
        for (SinkRecordField field : fields) {
            queries.addAll(super.getAlterTable(tableName, Collections.singleton(field)));
        }
        return queries;
    }
}

