/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import java.util.Iterator;

class StringBuilderUtil {
    StringBuilderUtil() {
    }

    public static void copiesToBuilder(StringBuilder builder, String delim, String item, int n) {
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append(delim);
            }
            builder.append(item);
        }
    }

    public static <T> void joinToBuilder(StringBuilder builder, String delim, Iterable<T> iter, Transform<T> transform) {
        StringBuilderUtil.joinToBuilder(builder, delim, iter, false, transform);
    }

    public static <T> void joinToBuilder(StringBuilder builder, String delim, Iterable<T> a, Iterable<T> b, Transform<T> transform) {
        boolean updated = StringBuilderUtil.joinToBuilder(builder, delim, a, false, transform);
        StringBuilderUtil.joinToBuilder(builder, delim, b, updated, transform);
    }

    private static <T> boolean joinToBuilder(StringBuilder builder, String delim, Iterable<T> items, boolean startingDelim, Transform<T> transform) {
        T next;
        boolean updated = false;
        Iterator<T> iter = items.iterator();
        if (iter.hasNext()) {
            if (startingDelim) {
                builder.append(delim);
            }
            if ((next = iter.next()) != null) {
                transform.apply(builder, next);
            }
            updated = true;
        }
        while (iter.hasNext()) {
            builder.append(delim);
            next = iter.next();
            if (next == null) continue;
            transform.apply(builder, next);
        }
        return updated;
    }

    public static interface Transform<T> {
        public void apply(StringBuilder var1, T var2);
    }
}

