/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class SqlServerDialect
extends DbDialect {
    public SqlServerDialect() {
        super("[", "]");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "decimal(38," + parameters.get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "date";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "time";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "datetime2";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "tinyint";
            }
            case INT16: {
                return "smallint";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "bigint";
            }
            case FLOAT32: {
                return "real";
            }
            case FLOAT64: {
                return "float";
            }
            case BOOLEAN: {
                return "bit";
            }
            case STRING: {
                return "varchar(max)";
            }
            case BYTES: {
                return "varbinary(max)";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public List<String> getAlterTable(String tableName, Collection<SinkRecordField> fields) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        builder.append(this.escaped(tableName));
        builder.append(" ADD");
        this.writeColumnsSpec(builder, fields);
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder();
        builder.append("merge into ");
        String tableName = this.escaped(table);
        builder.append(tableName);
        builder.append(" with (HOLDLOCK) AS target using (select ");
        StringBuilderUtil.joinToBuilder(builder, ", ", keyCols, cols, this.prefixedEscaper("? AS "));
        builder.append(") AS incoming on (");
        StringBuilderUtil.joinToBuilder(builder, " and ", keyCols, new StringBuilderUtil.Transform<String>(){

            @Override
            public void apply(StringBuilder builder, String col) {
                builder.append("target.").append(SqlServerDialect.this.escaped(col)).append("=incoming.").append(SqlServerDialect.this.escaped(col));
            }
        });
        builder.append(")");
        if (cols != null && cols.size() > 0) {
            builder.append(" when matched then update set ");
            StringBuilderUtil.joinToBuilder(builder, ",", cols, new StringBuilderUtil.Transform<String>(){

                @Override
                public void apply(StringBuilder builder, String col) {
                    builder.append(SqlServerDialect.this.escaped(col)).append("=incoming.").append(SqlServerDialect.this.escaped(col));
                }
            });
        }
        builder.append(" when not matched then insert (");
        StringBuilderUtil.joinToBuilder(builder, ", ", cols, keyCols, this.escaper());
        builder.append(") values (");
        StringBuilderUtil.joinToBuilder(builder, ",", cols, keyCols, this.prefixedEscaper("incoming."));
        builder.append(");");
        return builder.toString();
    }
}

