/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

public class PreparedStatementBinder {
    private final JdbcSinkConfig.PrimaryKeyMode pkMode;
    private final PreparedStatement statement;
    private final SchemaPair schemaPair;
    private final FieldsMetadata fieldsMetadata;
    private final JdbcSinkConfig.InsertMode insertMode;

    public PreparedStatementBinder(PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, JdbcSinkConfig.InsertMode insertMode) {
        this.pkMode = pkMode;
        this.statement = statement;
        this.schemaPair = schemaPair;
        this.fieldsMetadata = fieldsMetadata;
        this.insertMode = insertMode;
    }

    public void bindRecord(SinkRecord record) throws SQLException {
        Struct valueStruct = (Struct)record.value();
        int index = 1;
        switch (this.insertMode) {
            case INSERT: 
            case UPSERT: {
                index = this.bindKeyFields(record, index);
                this.bindNonKeyFields(record, valueStruct, index);
                break;
            }
            case UPDATE: {
                index = this.bindNonKeyFields(record, valueStruct, index);
                this.bindKeyFields(record, index);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.statement.addBatch();
    }

    private int bindKeyFields(SinkRecord record, int index) throws SQLException {
        switch (this.pkMode) {
            case NONE: {
                if (!this.fieldsMetadata.keyFieldNames.isEmpty()) {
                    throw new AssertionError();
                }
                break;
            }
            case KAFKA: {
                assert (this.fieldsMetadata.keyFieldNames.size() == 3);
                this.bindField(index++, Schema.STRING_SCHEMA, record.topic());
                this.bindField(index++, Schema.INT32_SCHEMA, record.kafkaPartition());
                this.bindField(index++, Schema.INT64_SCHEMA, record.kafkaOffset());
                break;
            }
            case RECORD_KEY: {
                if (this.schemaPair.keySchema.type().isPrimitive()) {
                    assert (this.fieldsMetadata.keyFieldNames.size() == 1);
                    this.bindField(index++, this.schemaPair.keySchema, record.key());
                    break;
                }
                for (String fieldName : this.fieldsMetadata.keyFieldNames) {
                    Field field = this.schemaPair.keySchema.field(fieldName);
                    this.bindField(index++, field.schema(), ((Struct)record.key()).get(field));
                }
                break;
            }
            case RECORD_VALUE: {
                for (String fieldName : this.fieldsMetadata.keyFieldNames) {
                    Field field = this.schemaPair.valueSchema.field(fieldName);
                    this.bindField(index++, field.schema(), ((Struct)record.value()).get(field));
                }
                break;
            }
            default: {
                throw new ConnectException("Unknown primary key mode: " + (Object)((Object)this.pkMode));
            }
        }
        return index;
    }

    private int bindNonKeyFields(SinkRecord record, Struct valueStruct, int index) throws SQLException {
        for (String fieldName : this.fieldsMetadata.nonKeyFieldNames) {
            Field field = record.valueSchema().field(fieldName);
            this.bindField(index++, field.schema(), valueStruct.get(field));
        }
        return index;
    }

    void bindField(int index, Schema schema, Object value) throws SQLException {
        PreparedStatementBinder.bindField(this.statement, index, schema, value);
    }

    static void bindField(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        if (value == null) {
            statement.setObject(index, null);
        } else {
            boolean bound = PreparedStatementBinder.maybeBindLogical(statement, index, schema, value);
            if (!bound) {
                switch (schema.type()) {
                    case INT8: {
                        statement.setByte(index, (Byte)value);
                        break;
                    }
                    case INT16: {
                        statement.setShort(index, (Short)value);
                        break;
                    }
                    case INT32: {
                        statement.setInt(index, (Integer)value);
                        break;
                    }
                    case INT64: {
                        statement.setLong(index, (Long)value);
                        break;
                    }
                    case FLOAT32: {
                        statement.setFloat(index, ((Float)value).floatValue());
                        break;
                    }
                    case FLOAT64: {
                        statement.setDouble(index, (Double)value);
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(index, (Boolean)value);
                        break;
                    }
                    case STRING: {
                        statement.setString(index, (String)value);
                        break;
                    }
                    case BYTES: {
                        byte[] bytes;
                        if (value instanceof ByteBuffer) {
                            ByteBuffer buffer = ((ByteBuffer)value).slice();
                            bytes = new byte[buffer.remaining()];
                            buffer.get(bytes);
                        } else {
                            bytes = (byte[])value;
                        }
                        statement.setBytes(index, bytes);
                        break;
                    }
                    default: {
                        throw new ConnectException("Unsupported source data type: " + schema.type());
                    }
                }
            }
        }
    }

    static boolean maybeBindLogical(PreparedStatement statement, int index, Schema schema, Object value) throws SQLException {
        if (schema.name() != null) {
            switch (schema.name()) {
                case "org.apache.kafka.connect.data.Date": {
                    statement.setDate(index, new Date(((java.util.Date)value).getTime()), DateTimeUtils.UTC_CALENDAR.get());
                    return true;
                }
                case "org.apache.kafka.connect.data.Decimal": {
                    statement.setBigDecimal(index, (BigDecimal)value);
                    return true;
                }
                case "org.apache.kafka.connect.data.Time": {
                    statement.setTime(index, new Time(((java.util.Date)value).getTime()), DateTimeUtils.UTC_CALENDAR.get());
                    return true;
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    statement.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()), DateTimeUtils.UTC_CALENDAR.get());
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

