/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.BufferedRecords;
import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

public class JdbcDbWriter {
    private final JdbcSinkConfig config;
    private final DbDialect dbDialect;
    private final DbStructure dbStructure;
    final CachedConnectionProvider cachedConnectionProvider;

    JdbcDbWriter(JdbcSinkConfig config, DbDialect dbDialect, DbStructure dbStructure) {
        this.config = config;
        this.dbDialect = dbDialect;
        this.dbStructure = dbStructure;
        this.cachedConnectionProvider = new CachedConnectionProvider(config.connectionUrl, config.connectionUser, config.connectionPassword){

            @Override
            protected void onConnect(Connection connection) throws SQLException {
                connection.setAutoCommit(false);
            }
        };
    }

    void write(Collection<SinkRecord> records) throws SQLException {
        Connection connection = this.cachedConnectionProvider.getValidConnection();
        HashMap<String, BufferedRecords> bufferByTable = new HashMap<String, BufferedRecords>();
        for (SinkRecord record : records) {
            String table = this.destinationTable(record.topic());
            BufferedRecords buffer = (BufferedRecords)bufferByTable.get(table);
            if (buffer == null) {
                buffer = new BufferedRecords(this.config, table, this.dbDialect, this.dbStructure, connection);
                bufferByTable.put(table, buffer);
            }
            buffer.add(record);
        }
        for (BufferedRecords buffer : bufferByTable.values()) {
            buffer.flush();
            buffer.close();
        }
        connection.commit();
    }

    void closeQuietly() {
        this.cachedConnectionProvider.closeQuietly();
    }

    String destinationTable(String topic) {
        String tableName = this.config.tableNameFormat.replace("${topic}", topic);
        if (tableName.isEmpty()) {
            throw new ConnectException(String.format("Destination table name for topic '%s' is empty using the format string '%s'", topic, this.config.tableNameFormat));
        }
        return tableName;
    }
}

