/*
 * Decompiled with CFR 0.152.
 */
package com.qubitproducts.hive.storage.jdbc.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordIterator
implements Iterator<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRecordIterator.class);
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;

    public JdbcRecordIterator(Connection conn, PreparedStatement ps, ResultSet rs) {
        this.conn = conn;
        this.ps = ps;
        this.rs = rs;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.rs.next();
        }
        catch (Exception se) {
            LOGGER.warn("hasNext() threw exception", se);
            return false;
        }
    }

    @Override
    public Map<String, String> next() {
        try {
            ResultSetMetaData metadata = this.rs.getMetaData();
            int numColumns = metadata.getColumnCount();
            HashMap<String, String> record = new HashMap<String, String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                String key = metadata.getColumnName(i + 1);
                String value = this.rs.getString(i + 1);
                if (value == null) {
                    value = NullWritable.get().toString();
                }
                record.put(key, value);
            }
            return record;
        }
        catch (Exception e) {
            LOGGER.warn("next() threw exception", e);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public void close() {
        try {
            this.rs.close();
            this.ps.close();
            this.conn.close();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to close database objects", e);
        }
    }
}

