/*
 * Decompiled with CFR 0.152.
 */
package com.qubitproducts.hive.storage.jdbc.dao;

import com.qubitproducts.hive.storage.jdbc.conf.DatabaseType;
import com.qubitproducts.hive.storage.jdbc.conf.JdbcStorageConfig;
import com.qubitproducts.hive.storage.jdbc.dao.DatabaseAccessor;
import com.qubitproducts.hive.storage.jdbc.dao.GenericJdbcDatabaseAccessor;
import com.qubitproducts.hive.storage.jdbc.dao.MySqlDatabaseAccessor;
import org.apache.hadoop.conf.Configuration;

public class DatabaseAccessorFactory {
    private DatabaseAccessorFactory() {
    }

    public static DatabaseAccessor getAccessor(DatabaseType dbType) {
        GenericJdbcDatabaseAccessor accessor = null;
        switch (dbType) {
            case MYSQL: {
                accessor = new MySqlDatabaseAccessor();
                break;
            }
            default: {
                accessor = new GenericJdbcDatabaseAccessor();
            }
        }
        return accessor;
    }

    public static DatabaseAccessor getAccessor(Configuration conf) {
        DatabaseType dbType = DatabaseType.valueOf(conf.get(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()));
        return DatabaseAccessorFactory.getAccessor(dbType);
    }
}

