/*
 * Decompiled with CFR 0.152.
 */
package com.qubitproducts.hive.storage.jdbc;

import com.qubitproducts.hive.storage.jdbc.conf.JdbcStorageConfig;
import com.qubitproducts.hive.storage.jdbc.conf.JdbcStorageConfigManager;
import com.qubitproducts.hive.storage.jdbc.dao.DatabaseAccessor;
import com.qubitproducts.hive.storage.jdbc.dao.DatabaseAccessorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSerDe
implements SerDe {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSerDe.class);
    private StructObjectInspector objectInspector;
    private int numColumns;
    private String[] hiveColumnTypeArray;
    private List<String> columnNames;
    private List<String> row;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        try {
            LOGGER.debug("Initializing the SerDe");
            if (tbl.containsKey(JdbcStorageConfig.DATABASE_TYPE.getPropertyName())) {
                Configuration tableConfig = JdbcStorageConfigManager.convertPropertiesToConfiguration(tbl);
                DatabaseAccessor dbAccessor = DatabaseAccessorFactory.getAccessor(tableConfig);
                this.columnNames = dbAccessor.getColumnNames(tableConfig);
                this.numColumns = this.columnNames.size();
                String[] hiveColumnNameArray = this.parseProperty(tbl.getProperty("columns"), ",");
                if (this.numColumns != hiveColumnNameArray.length) {
                    throw new SerDeException("Expected " + this.numColumns + " columns. Table definition has " + hiveColumnNameArray.length + " columns");
                }
                List<String> hiveColumnNames = Arrays.asList(hiveColumnNameArray);
                this.hiveColumnTypeArray = this.parseProperty(tbl.getProperty("columns.types"), ":");
                if (this.hiveColumnTypeArray.length == 0) {
                    throw new SerDeException("Received an empty Hive column type definition");
                }
                ArrayList<JavaStringObjectInspector> fieldInspectors = new ArrayList<JavaStringObjectInspector>(this.numColumns);
                for (int i = 0; i < this.numColumns; ++i) {
                    fieldInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                }
                this.objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(hiveColumnNames, fieldInspectors);
                this.row = new ArrayList<String>(this.numColumns);
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while initializing the SqlSerDe", e);
            throw new SerDeException((Throwable)e);
        }
    }

    private String[] parseProperty(String propertyValue, String delimiter) {
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            return new String[0];
        }
        return propertyValue.split(delimiter);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        LOGGER.debug("Deserializing from SerDe");
        if (!(blob instanceof MapWritable)) {
            throw new SerDeException("Expected MapWritable. Got " + blob.getClass().getName());
        }
        if (this.row == null || this.columnNames == null) {
            throw new SerDeException("JDBC SerDe hasn't been initialized properly");
        }
        this.row.clear();
        MapWritable input = (MapWritable)blob;
        Text columnKey = new Text();
        for (int i = 0; i < this.numColumns; ++i) {
            columnKey.set(this.columnNames.get(i));
            Writable value = input.get((Object)columnKey);
            if (value == null) {
                this.row.add(null);
                continue;
            }
            this.row.add(value.toString());
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("Writes are not allowed");
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

