/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.partitioners;

import com.google.common.base.Joiner;
import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.windowsazure.storage.table.TableQuery;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.Text;

public class PartitionKeyRangeInputSplit
extends AzureTableInputSplit {
    private String partitionKeyStart;
    private String partitionKeyEnd;

    PartitionKeyRangeInputSplit() {
    }

    public PartitionKeyRangeInputSplit(String partitionKeyStart, String partitionKeyEnd) {
        this.partitionKeyStart = partitionKeyStart;
        this.partitionKeyEnd = partitionKeyEnd;
    }

    public String getPartitionKeyStart() {
        return this.partitionKeyStart;
    }

    public String getPartitionKeyEnd() {
        return this.partitionKeyEnd;
    }

    public void write(DataOutput out) throws IOException {
        PartitionKeyRangeInputSplit.writeNullableString(out, this.partitionKeyStart);
        PartitionKeyRangeInputSplit.writeNullableString(out, this.partitionKeyEnd);
    }

    public void readFields(DataInput in) throws IOException {
        this.partitionKeyStart = PartitionKeyRangeInputSplit.readNullableString(in);
        this.partitionKeyEnd = PartitionKeyRangeInputSplit.readNullableString(in);
    }

    @Override
    public TableQuery<WritableEntity> getQuery() {
        TableQuery query = TableQuery.from(WritableEntity.class);
        ArrayList<String> clauses = new ArrayList<String>();
        if (this.partitionKeyStart != null) {
            clauses.add(TableQuery.generateFilterCondition((String)"PartitionKey", (String)"ge", (String)this.partitionKeyStart));
        }
        if (this.partitionKeyEnd != null) {
            clauses.add(TableQuery.generateFilterCondition((String)"PartitionKey", (String)"lt", (String)this.partitionKeyEnd));
        }
        if (clauses.size() > 0) {
            query = query.where(Joiner.on((String)" and ").join(clauses));
        }
        return query;
    }

    private static void writeNullableString(DataOutput out, String s) throws IOException {
        out.writeBoolean(s != null);
        if (s != null) {
            Text.writeString((DataOutput)out, (String)s);
        }
    }

    private static String readNullableString(DataInput in) throws IOException {
        boolean stringExists = in.readBoolean();
        if (stringExists) {
            return Text.readString((DataInput)in);
        }
        return null;
    }
}

