/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.partitioners;

import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.BaseAzureTablePartitioner;
import com.microsoft.hadoop.azure.partitioners.PartitionKeyRangeInputSplit;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import com.microsoft.windowsazure.storage.table.TableQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class AzureDiagnosticsLogsPartitioner
extends BaseAzureTablePartitioner {
    private long splitIntervalSeconds = 1800L;

    @Override
    public void configure(Configuration config) {
        this.splitIntervalSeconds = config.getLong(ConfigurationKeys.INTERVAL_PER_SPLIT.key, this.splitIntervalSeconds);
        if (this.splitIntervalSeconds <= 0L) {
            throw new IllegalArgumentException(ConfigurationKeys.INTERVAL_PER_SPLIT.key + " should be a positive integer");
        }
    }

    @Override
    public List<AzureTableInputSplit> getSplits(CloudTable table) throws StorageException {
        ArrayList<AzureTableInputSplit> ret = new ArrayList<AzureTableInputSplit>();
        List<String> partitionKeys = this.getPartitionKeysAtIntervals(table);
        if (partitionKeys.size() == 0) {
            return ret;
        }
        for (int i = 0; i < partitionKeys.size() - 1; ++i) {
            ret.add(new PartitionKeyRangeInputSplit(partitionKeys.get(i), partitionKeys.get(i + 1)));
        }
        ret.add(new PartitionKeyRangeInputSplit(partitionKeys.get(partitionKeys.size() - 1), null));
        return ret;
    }

    List<String> getPartitionKeysAtIntervals(CloudTable table) throws StorageException {
        DynamicTableEntity currentEntity;
        TableQuery getNextKeyQuery = AzureDiagnosticsLogsPartitioner.getFirstRowNoFields();
        ArrayList<String> ret = new ArrayList<String>();
        while ((currentEntity = AzureDiagnosticsLogsPartitioner.GetSingleton(table.execute(getNextKeyQuery))) != null) {
            ret.add(currentEntity.getPartitionKey());
            long currentTicks = Long.parseLong(currentEntity.getPartitionKey());
            long currentSeconds = currentTicks / 10000000L;
            long nextSeconds = currentSeconds + this.splitIntervalSeconds;
            long nextTicks = nextSeconds * 10000000L;
            String nextPartitionKey = "0" + nextTicks;
            getNextKeyQuery = TableQuery.from(DynamicTableEntity.class).select(new String[0]).where("PartitionKey ge '" + nextPartitionKey + "'").take(Integer.valueOf(1));
        }
        return ret;
    }

    public static enum ConfigurationKeys {
        INTERVAL_PER_SPLIT("azure.table.logpartitioner.split.interval.seconds");

        private final String key;

        private ConfigurationKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

