/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.oldinterface;

import com.microsoft.hadoop.azure.AzureTableInputSplit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class WrapperSplit
extends FileSplit
implements Writable {
    private AzureTableInputSplit wrappedSplit;

    public WrapperSplit() {
        super((Path)null, 0L, 0L, (String[])null);
    }

    public WrapperSplit(AzureTableInputSplit wrappedSplit, Path file, JobConf conf) {
        super(file, 0L, 0L, conf);
        this.wrappedSplit = wrappedSplit;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        String className = in.readUTF();
        try {
            this.wrappedSplit = (AzureTableInputSplit)((Object)ReflectionUtils.newInstance(Class.forName(className), (Configuration)new Configuration()));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.wrappedSplit.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(((Object)((Object)this.wrappedSplit)).getClass().getName());
        this.wrappedSplit.write(out);
    }

    public AzureTableInputSplit getWrappedSplit() {
        return this.wrappedSplit;
    }
}

