/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.oldinterface;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.hadoop.azure.oldinterface.WrapperSplit;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.TableQuery;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RecordReader;

public class OldAzureTableReader
implements RecordReader<Text, WritableEntity> {
    private Iterator<WritableEntity> queryResults;
    private long pos;

    OldAzureTableReader(WrapperSplit split, Configuration conf) throws IOException {
        CloudTableClient tableClient = AzureTableConfiguration.createTableClient(conf);
        String tableName = AzureTableConfiguration.getTableName(conf);
        TableQuery<WritableEntity> query = split.getWrappedSplit().getQuery();
        try {
            this.queryResults = tableClient.getTableReference(tableName).execute(query).iterator();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void close() throws IOException {
    }

    public Text createKey() {
        return new Text();
    }

    public WritableEntity createValue() {
        return new WritableEntity();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public float getProgress() throws IOException {
        return 0.5f;
    }

    public boolean next(Text key, WritableEntity value) throws IOException {
        if (this.queryResults.hasNext()) {
            WritableEntity obtained = this.queryResults.next();
            key.set(obtained.getRowKey());
            value.setPartitionKey(obtained.getPartitionKey());
            value.setRowKey(obtained.getRowKey());
            value.setTimestamp(obtained.getTimestamp());
            value.setProperties(obtained.getProperties());
            ++this.pos;
            return true;
        }
        return false;
    }
}

