/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.oldinterface;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.AzureTablePartitioner;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.hadoop.azure.oldinterface.OldAzureTableReader;
import com.microsoft.hadoop.azure.oldinterface.WrapperSplit;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class OldAzureTableInputFormat
implements InputFormat<Text, WritableEntity> {
    public RecordReader<Text, WritableEntity> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new OldAzureTableReader((WrapperSplit)split, (Configuration)job);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        AzureTablePartitioner partitioner = AzureTableConfiguration.getPartitioner((Configuration)job);
        CloudTable table = AzureTableConfiguration.getTableReference((Configuration)job);
        ArrayList<WrapperSplit> ret = new ArrayList<WrapperSplit>();
        Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)job);
        try {
            for (AzureTableInputSplit split : partitioner.getSplits(table)) {
                ret.add(new WrapperSplit(split, tablePaths[0], job));
            }
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        return ret.toArray(new InputSplit[0]);
    }
}

